/* 3DX_PIR_Servo

 This example code is in the public domain.

 modified 14 Nov 2017
 by Open Source Classroom, LLC
 http://www.osc3d.com
*/

// include the library code:
#include <LiquidCrystal.h>
#include <Servo.h>

// initialize the library by associating any needed LCD interface pin
// with the arduino pin number it is connected to
const int rs = 12, en = 11, d4 = 10, d5 = 9, d6 = 8, d7 = 7;

LiquidCrystal lcd(7, 8, 9, 10, 11, 12);  //  digital pins for LCD

Servo myservo;                       // create servo object to control a servo

int pirSensor = 1;                   // choose the input pin for PIR sensor

int pirState = LOW;                  // we start, assuming no motion detected
int pos = 0;                         // variable to store the servo position
int val = 0;                         // variable for reading the PIR pin status

void setup() {
    lcd.begin(16, 2);                //  set up the LCD's number of columns and rows (columns, rows):
    myservo.attach(13);              // attaches the servo on pin 9 to the servo object
    pinMode(pirSensor, INPUT);       //  declare PIR sensor as input

 // Print start-up message to the LCD.
   
  lcd.setCursor(0, 0);               //  Set cursor position to beginning of top row (column, row)
  lcd.print("Motion Detecting");     //  Text displayed on first line of LCD
  lcd.setCursor(0, 1);               //  Set cursor position to beginning of bottom row (column, row)
  lcd.print("Drawbridge LCD");       //  Text displayed on second line  LCD
  delay(3000);                       //  Display message for 5 seconds
  lcd.clear();                       //   clear out the LCD screen       
}  

void loop(){

//  Print message to LCd screen when NO MOTION is detected
    
     lcd.setCursor(0, 0);            //  Set cursor position to beginning of top row (column, row)
     lcd.print("All is calm,    ");  //  LCD screen is curious is there is anyone out there
     lcd.setCursor(0, 1);            //  Set cursor position to beginning of bottom row (column, row)
     lcd.print("DRAWBRIDGE OPEN ");  //  LCD screen is curious is there is anyone out there{
  
  //  Print message to LCd screen when NO MOTION is detected
    
  val = digitalRead(pirSensor);      // read PIR input value
 
  if                                 //  "if" is the first half of an "if/else" argument
    (val == HIGH){

    lcd.setCursor(0, 0);             //  Set cursor position to beginning of bottom row (column, row)
    lcd.print("INTRUDER ALERT!!");   //  Print message to LCD screen
    lcd.setCursor(0, 1);             //  Set cursor position to beginning of bottom row (column, row)
    lcd.print("RAISE THE BRIDGE");   //  Text displayed on second line  LCD
    
    myservo.write(62);               // tell servo to go to position of 62 degrees  --> Close the Drawbridge
    delay(5000);                    //  Wait 10 seconds
    }
  else {                             // if "else" is the second half of the "if/else" argument
    myservo.write(0);                // tell servo to go to position of 0 degrees --> Open the Drawbridge
   
}
}

