
module roundedRect(size, radius)
{
	x = size[0];
	y = size[1];
	z = size[2];

	linear_extrude(height=z)
	hull()
	{
		// place 4 circles in the corners, with the given radius
		translate([(-x/2)+(radius/2), (-y/2)+(radius/2), 0])
		circle(r=radius);
	
		translate([(x/2)-(radius/2), (-y/2)+(radius/2), 0])
		circle(r=radius);
	
		translate([(-x/2)+(radius/2), (y/2)-(radius/2), 0])
		circle(r=radius);
	
		translate([(x/2)-(radius/2), (y/2)-(radius/2), 0])
		circle(r=radius);
	}
}

module drill(x,y)
{
    color("green")
        translate([x-52,y-75,-10])
            cylinder(r=2+0.2, h=20, $fn=50, center=false);
}

module cut()
{
    x = 40;
    y = -90; 
    z = -153;//153    

    union()
    {
        color("Maroon")
        {
            translate([x,y,z])
                rotate([0,0,90])
                    import("Corner_3Way_Cut.stl");
            
            translate([x,y,z+2.5])
                rotate([0,0,90])
                    import("Corner_3Way_Cut.stl");
        }   
            
        color("Green")
        {
           translate([x+3,y+14,-10])
            cylinder(r=4, h=20, $fn=50, center=false);
        }
    }
}

difference()  // uncomment for the release 
//union()     // uncomment for the debug
{
    
        color("Red")
            translate([0,0,-5])
                roundedRect([86+19-5,145,4], 5, $fn=20);
    
        color("Blue")
            translate([-9,0.5,-7])
                roundedRect([65-5,125,8], 5, $fn=20);
    
        y_left = 6+0.5;
        //Left side
        drill(5,y_left);
        drill(70,y_left);
        //drill(80,y_left);
    
        y_right = 143+0.5;
        //Right side
        drill(5,y_right);
        drill(70,y_right);
        drill(80,y_right);
    
        x_drill = 96.5;
        //rail drills
        drill(x_drill,25);
        drill(x_drill,75);
        drill(x_drill,145);
        
        cut();
}