mode="half"; // [normal, half]

// Dimensiones
xu=214.5;
xb=197;
y=120;
zu=5.2;
zb=5.5;
zum=14.4;
zbm=13.5;

x_int=175;
y_int=100;

mic=true;
led=true;

$fn=60;

Vertex = [
  [ -xb/2, -y/2, 0 ],  // 0
  [ 0, -y/2, 0 ],      // 1
  [ -xu/2, y/2, 0 ],   // 2
  [ 0, y/2, 0 ],       // 3
  [ -xb/2, -y/2, zb ], // 4
  [ 0, -y/2, zbm ],   // 5
  [ -xu/2, y/2, zu ],  // 6
  [ 0, y/2, zum ]];   // 7

Faces = [
  [0,1,3,2],  // floor
  [6,7,5],  // ceil-left-up
  [4,6,5],  // ceil-left-bottom
  [0,4,5,1],  // bottom
  [1,5,7,3],  // right
  [2,3,7,6],  // up
  [0,2,6,4]]; // left


module fascia_surface_half() {
    difference() {
        polyhedron( Vertex, Faces, convexity = 10 );
        cube([x_int, y_int, 40], center=true);
    }
}

// Left piece
difference() {
    fascia_surface_half();
    if (mic) {
        translate([-104+7.25,y/2-28.6,0]) cylinder(h=20, d=6.5);
    }
}
// Right piece
if (mode=="half") {
    translate([-70, 30, 0]) mirror([1,0,0]) difference() {
        fascia_surface_half();
        if (led) {
            translate([-104+5.5,y/2-28.6,0]) cylinder(h=20, d=5.4);
            translate([-104+5.5,y/2-28.6,0]) cylinder(h=1, d=6.4);
            translate([-104+5.5,y/2-28.6,1]) cylinder(h=8, d1=6.4, d2=0);
        }
    }
} else {
    mirror([1,0,0]) difference() {
        fascia_surface_half();
        if (led) {
            translate([-104+7.25,y/2-28.6,0]) cylinder(h=20, d=5.4);
            translate([-104+7.25,y/2-28.6,0]) cylinder(h=1, d=6.4);
            translate([-104+7.25,y/2-28.6,1]) cylinder(h=8, d1=6.4, d2=0);
        }
    }
}

module ruler(length)
{
    mark_width = 0.125;
    mark_depth = 0.05;

    difference()
    {
        cube( [1, length, 8 ] );
        for ( i = [1:length-1] )
        {
            translate( [mark_depth, i, 0] ) cube( [1, mark_width, 3 ] );
            translate( [-mark_depth, i, 0] ) cube( [1, mark_width, 3 ] );
            if (i % 5 == 0)
            {
                translate( [mark_depth, i, 0] ) cube( [5, mark_width, 5 ] );
                translate( [-mark_depth, i, 0] ) cube( [5, mark_width, 5 ] );
            }
            if (i % 10 == 0)
            {
                translate( [mark_depth, i, 0] ) cube( [10, mark_width, 7 ] );
                translate( [-mark_depth, i, 0] ) cube( [10, mark_width, 7 ] );
            }
        }
    }
}
*translate([0,y/2-28.6,0]) rotate(90, [0,0,1]) rotate(90, [0,1,0]) ruler(200);
