x_frame_ext = 196;    // Anchura del marco
y_frame_ext = 114.4;  // Altura del marco
z_frame = 5.2;         // Profundidad del marco

x_screen = 166.2;
y_screen = 100.6;
tolerance = 0.6;
x_screen_despl = 1.5;
y_screen_despl = -1.3;

x_mont = 36.7;
y_mont = 18;
z_mont = 4;

x_mont_hole = 15.2;
y_mont_hole = 8.4;
z_mont_hole = 2.2;

x_stand = 9.3;
y_stand = 97;
z_stand = 0.4;

x_screw_dist = 126;
y_screw_dist = 65.6;

y_tool_hole = 1.6;

$fn=50;

// --------------------

marco();

resalte_pantalla();

montantes();

// --------------------

// Marco + Lengüetas + Soporte inferior
module marco() {
    difference() {
        union() {
            cube([x_frame_ext, y_frame_ext, z_frame], center=true);
            // Soporte inferior
            translate([0, -2.2-y_frame_ext/2, -(8.9-z_frame)/2]) cube([x_frame_ext-8, 4.4, 8.9], center=true);
            // Lengüetas
            lenguetas();
            translate([0,2.6-y_frame_ext/2,-z_frame/2]) rotate(180, [0,0,1]) lengueta_inferior();
        }
        translate([x_screen_despl, y_screen_despl, 0]) cube([x_screen+tolerance, y_screen+tolerance, z_frame], center=true);
        translate([0,-(y_screen+tolerance+1.5)/2+y_screen_despl, 0]) cube([52, 1.5, z_frame], center=true);
        translate([0, -y_frame_ext/2, 0]) cube([22, y_tool_hole, 92], center=true);
    }
}

// Resalte para equilibrar pantalla
module resalte_pantalla() {
    translate([x_stand/2+(x_screen+tolerance)/2+x_screen_despl,(y_screen+tolerance-y_stand)/2+y_screen_despl,(z_frame+z_stand)/2]) cube([x_stand,y_stand,z_stand], center=true);
}

// Montantes
module montantes() {
    translate([x_screw_dist/2+x_screen_despl, 35.3+y_screen_despl, -z_mont-z_frame/2]) montante();
    translate([x_screw_dist/2+x_screen_despl, -30.3+y_screen_despl, -z_mont-z_frame/2]) montante();
    mirror([1,0,0]) translate([x_screw_dist/2-x_screen_despl, 35.3+y_screen_despl, -z_mont-z_frame/2]) montante();
    mirror([1,0,0]) translate([x_screw_dist/2-x_screen_despl, -30.3+y_screen_despl, -z_mont-z_frame/2]) montante();
}

// --------------------

module lenguetas() {
    translate([0,y_frame_ext/2-6.3,-14-z_frame/2]) lengueta();
    translate([66.4,y_frame_ext/2-6.3,-14-z_frame/2]) lengueta();
    translate([-66.4,y_frame_ext/2-6.3,-14-z_frame/2]) lengueta();
}

module lengueta() {
    translate([-5,0,0]) {
        cube([10, 2, 14]);
        translate([0,2,0]) difference() {
            cube([10,5,8.5]);
            rotate(145, [1,0,0]) translate([-1,-15,-15]) cube([12,15,15]);
        }
    }
}

module lengueta_inferior() {
    x_leng_inf = 30;
    z_leng_inf = 48.5-z_frame;
    translate([-x_leng_inf/2,0,-(z_leng_inf+8.5)]) {
        translate([0,-1,0]) cube([x_leng_inf, 3, z_leng_inf+8.5]);
        translate([0,2,0]) difference() {
            cube([x_leng_inf,5,8.5]);
            rotate(145, [1,0,0]) translate([-1,-15,-15]) cube([x_leng_inf+2,15,15]);
        }
    }
}

module montante() {
    difference() {
        union() {
            translate([7.85,0,z_mont/2]) cube([x_mont, y_mont, z_mont], center=true);
            translate([0, 0, -4]) cylinder(h=4,r=3);
        }
        translate([0,0,z_mont-z_mont_hole/2]) cube([x_mont_hole,y_mont_hole,z_mont_hole], center=true);
        cylinder(h=20,d=3,center=true);
    }
}
