/**
 * Marlin 3D Printer Firmware
 * Copyright (C) 2016 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (C) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/**
 * Custom Bitmap for splashscreen
 *
 * You may use one of the following tools to generate the C++ bitmap array from
 * a black and white image:
 *
 *  - http://www.marlinfw.org/tools/u8glib/converter.html
 *  - http://www.digole.com/tools/PicturetoC_Hex_converter.php
 */
//custom screen can be up to 112 wide and 64 high

#include <avr/pgmspace.h>

#define CUSTOM_BOOTSCREEN_TIMEOUT   2500
#define CUSTOM_BOOTSCREEN_BMPWIDTH  112
#define CUSTOM_BOOTSCREEN_BMPHEIGHT 64

// Width: 128, Height: 64
const unsigned char custom_start_bmp[896] PROGMEM = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x1F, 0xF8, 0x00, 0x1F, 0xFF, 0xFF, 0xF8, 0x01, 0xF8, 0x07, 0xE0, 0x1E, 0x00, 0xF8, 0x1F, 0xFF,
0x80, 0x3F, 0xFF, 0xFF, 0xF8, 0x03, 0xF8, 0x3F, 0xFC, 0x1F, 0x00, 0xF8, 0x1F, 0xFF, 0xE0, 0x3F,
0xFF, 0xFF, 0xF8, 0x03, 0xF8, 0x7F, 0xFE, 0x1F, 0x80, 0xF8, 0x1F, 0xFF, 0xF0, 0x3F, 0xFF, 0xFF,
0xFC, 0x03, 0xF8, 0xFF, 0xFF, 0x1F, 0xC0, 0xF8, 0x1F, 0x8F, 0xF8, 0x7F, 0xC0, 0x07, 0xFC, 0x07,
0xF9, 0xFE, 0x7F, 0x9F, 0xC0, 0xF8, 0x1F, 0x81, 0xF8, 0x7B, 0xC0, 0x07, 0xFE, 0x07, 0xF9, 0xF8,
0x1F, 0x9F, 0xE0, 0xF8, 0x1F, 0x80, 0xF8, 0xFB, 0xC0, 0x07, 0xFE, 0x0F, 0xFB, 0xF0, 0x0F, 0xDF,
0xF0, 0xF8, 0x1F, 0x80, 0x78, 0xF9, 0xE0, 0x07, 0xFE, 0x0F, 0x7B, 0xE0, 0x0F, 0xDF, 0xF0, 0xF8,
0x1F, 0x80, 0x7C, 0xF1, 0xE0, 0x07, 0xDF, 0x0F, 0x7F, 0xE0, 0x07, 0xDE, 0xF8, 0xF8, 0x1F, 0x80,
0x7D, 0xF1, 0xFF, 0xFF, 0xDF, 0x1F, 0x7F, 0xE0, 0x07, 0xFE, 0xFC, 0xF8, 0x1F, 0x80, 0x7D, 0xF0,
0xFF, 0xFF, 0xDF, 0x1E, 0x7F, 0xE0, 0x07, 0xFE, 0x7C, 0xF8, 0x1F, 0x80, 0x7F, 0xE0, 0xFF, 0xFF,
0xCF, 0x1E, 0x7F, 0xE0, 0x07, 0xFE, 0x3E, 0xF8, 0x1F, 0x80, 0x7F, 0xE0, 0xFF, 0xFF, 0xCF, 0x3E,
0x7F, 0xE0, 0x07, 0xFE, 0x1F, 0xF8, 0x1F, 0x80, 0x7F, 0xFF, 0xF8, 0x07, 0xC7, 0xBC, 0x7F, 0xE0,
0x07, 0xDE, 0x1F, 0xF8, 0x1F, 0x80, 0x7F, 0xFF, 0xF8, 0x07, 0xC7, 0xBC, 0x7B, 0xE0, 0x07, 0xDE,
0x0F, 0xF8, 0x1F, 0x80, 0xFF, 0xFF, 0xFC, 0x07, 0xC7, 0xF8, 0x7B, 0xF0, 0x0F, 0xDE, 0x07, 0xF8,
0x1F, 0x81, 0xFF, 0xFF, 0xFC, 0x07, 0xC3, 0xF8, 0x7B, 0xF8, 0x1F, 0x9E, 0x07, 0xF8, 0x1F, 0x87,
0xFF, 0xC0, 0x7E, 0x07, 0xC3, 0xF8, 0x79, 0xFC, 0x3F, 0x9E, 0x03, 0xF8, 0x1F, 0xFF, 0xF7, 0x80,
0x7F, 0xFF, 0xC3, 0xF0, 0x78, 0xFF, 0xFF, 0x1E, 0x01, 0xF8, 0x1F, 0xFF, 0xEF, 0x80, 0x3F, 0xFF,
0xC1, 0xF0, 0x78, 0x7F, 0xFE, 0x1E, 0x01, 0xF8, 0x1F, 0xFF, 0x8F, 0x80, 0x3F, 0xFF, 0xC1, 0xF0,
0x78, 0x3F, 0xFC, 0x1E, 0x00, 0xF8, 0x1F, 0xFC, 0x0F, 0x00, 0x3F, 0xFF, 0xC0, 0xE0, 0x78, 0x0F,
0xF0, 0x1E, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0xF8, 0x3E, 0x7C, 0xD9, 0xBF,
0x7D, 0xF0, 0x3E, 0x7C, 0xD9, 0xBF, 0x7D, 0xF0, 0x36, 0xCC, 0x33, 0x66, 0xD9, 0x8C, 0x61, 0x98,
0x33, 0x66, 0xD9, 0x8C, 0x61, 0x98, 0x06, 0xCC, 0x33, 0x66, 0xDD, 0x8C, 0x61, 0x98, 0x33, 0x66,
0xDD, 0x8C, 0x61, 0x98, 0x0C, 0xCC, 0x33, 0x66, 0xDD, 0x8C, 0x7D, 0x98, 0x33, 0x66, 0xDD, 0x8C,
0x7D, 0x98, 0x06, 0xCC, 0x3E, 0x7C, 0xDB, 0x8C, 0x61, 0x98, 0x3E, 0x7C, 0xDB, 0x8C, 0x61, 0xF0,
0x06, 0xCC, 0x30, 0x6C, 0xDB, 0x8C, 0x61, 0x98, 0x30, 0x6C, 0xDB, 0x8C, 0x61, 0xB0, 0x36, 0xCC,
0x30, 0x66, 0xD9, 0x8C, 0x61, 0x98, 0x30, 0x66, 0xD9, 0x8C, 0x61, 0x98, 0x1C, 0xF8, 0x30, 0x63,
0xD9, 0x8C, 0x7D, 0xF0, 0x30, 0x63, 0xD9, 0x8C, 0x7D, 0x8C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F,
0x22, 0x3E, 0x1E, 0x1C, 0x44, 0x71, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xA2, 0x08,
0x11, 0x22, 0x6C, 0x89, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x94, 0x08, 0x11, 0x22,
0x6C, 0x89, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x08, 0x08, 0x11, 0x22, 0x6C, 0x89,
0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x88, 0x08, 0x11, 0x22, 0x54, 0x89, 0x30, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x88, 0x08, 0x11, 0x22, 0x54, 0x89, 0x30, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x0F, 0x08, 0x08, 0x9E, 0x1C, 0x54, 0x71, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

