$fn=100;

module schraube() {
 translate([0,0,-20]) cylinder(d=5.5,h=20);
 translate([0,0,0]) cylinder(d1=5.5,d2=11,h=5.5);
 translate([0,0,5.5]) cylinder(d=11,h=250);
}


module platte() {
translate([0,0,-4]) {
cube([150,150,4]);
translate([80,0,4]) cube([70,9,9]);
translate([0,0,4]) cube([9,150,9]);
}
}

module deckelecke() {
translate([9,0,0]) cube([80-9,9,9]);
%platte();
}

nut=8;


module ecke_add() {

translate([-15,-15,0]) cube([nut+10+10+15,nut+10+10+15,5]);   
translate([-15,-15,0]) cube([15.5,15.5,240]);       
cube([nut+10+10,3+4.2+3,240]);
cube([3+4.2+3,nut+10,240]);

%hull() {
translate([-15,-15,0]) cube([nut+10+10+15,nut+10,5]);    
translate([0,0,239]) cube([nut+10+10,3+4.2+3,1]);
}
%hull() {
translate([-15,-15,0]) cube([nut+18,nut+10+10+15,5]);    
translate([0,0,239]) cube([3+4.2+3,nut+10,1]); 
}
}

module ecke_sub() {
  translate([10+10,3,0]) cube([30,4.2,240]);  
  translate([3,10,0]) cube([4.2,30,240]); 
  translate([-10,0,230]) cube([10,50,10]);
  translate([0,-10,230]) cube([50,10,10]);  
  translate([20,20,0])schraube();
  translate([-7.5,13,0])schraube();
  translate([10.5,-7.5,0])schraube();
translate([-25,-60,0]) rotate([0,4,45]) cube([50,50,250]);
}

module ecke() {
difference() { ecke_add(); ecke_sub(); }
%translate([-10,-10,240]) rotate([180,0,90]) platte();
}

griffl=110;
griffih=40;
griffb=20;
griffsl=2.8;

module griff_add() {
    translate([0,0,15]) rotate([90,0,0]) resize([0,35,0]) rotate_extrude(angle=180) translate([(griffl+griffb)/2,0,0]) circle(griffb/2);
    translate([(griffl+griffb)/2,0,0]) cylinder(d=griffb,h=15);
    translate([-(griffl+griffb)/2,0,0]) cylinder(d=griffb,h=15);
}

module griff_sub() {
   translate([-100,-griffb,0]) cube([200,griffb/2+.15,100]); 
   translate([(griffl+griffb)/2,0,0]) cylinder(d=griffsl,h=15);
   translate([-(griffl+griffb)/2,0,0]) cylinder(d=griffsl,h=15);
}


module griff() {
rotate([90,0,0])
difference() {
griff_add();
griff_sub();
}
}

module scheibe() {
difference() {
    translate([0,0,-20+4]) intersection() { sphere(20); translate([0,0,20-4]) cylinder(d=griffb,h=4); }
    //cylinder(d=griffb,h=4);
    cylinder(d1=5.5,d2=9.5,h=4);
}
}


lamelle=0.84;
lwinkel=30;
holz=4.1;
lglaenge=150;
lhoehe=100;
lgbreite=holz+2*lamelle;
llaenge=lgbreite/sin(lwinkel)/2;
lanz=31;

module luftgitter() {
translate([0,-lgbreite/2,0]) cube([lglaenge,lgbreite,1.1]);
difference() {
    union() {
        translate([-8,-lgbreite/2,lhoehe-1.2]) cube([lglaenge+2*8,lgbreite,1.2+8]);
        translate([-8,-lgbreite/2,0]) cube([8+1.22,lgbreite,lhoehe+8]);
        translate([lglaenge-1.22-1,-lgbreite/2,0]) cube([8+1.22+1,lgbreite,lhoehe+8]);
    }
        translate([-8,-lgbreite/2+lamelle,lhoehe]) cube([lglaenge+2*8,holz,1.2+8]);
        translate([-8,-lgbreite/2+lamelle,0]) cube([8,holz,lhoehe+8]);
        translate([lglaenge,-lgbreite/2+lamelle,0]) cube([8+1.22,holz,lhoehe+8]);
}
        
for(i=[0:lanz])
translate([i*llaenge*4/5,0,0]) {
    difference() {
        union() {
            translate([0,0,0]) rotate([0,0,-lwinkel]) cube([llaenge,lamelle,lhoehe]);
           translate([0,0,0]) rotate([0,0,lwinkel]) translate([0,-lamelle,0]) cube([llaenge,lamelle,lhoehe]); 
        }
        translate([0,0,0]) rotate([0,0,-lwinkel]) translate([0,-lamelle,0]) cube([llaenge,lamelle,lhoehe]);
        translate([0,0,0]) rotate([0,0,lwinkel]) translate([0,0,0]) cube([llaenge,lamelle,lhoehe]); 
        
    }
}
}

module absaug_add() {
    hull() {
    cylinder(d=100+2*3,h=36);
    translate([-(100+6+16)/2,-(100+6+16)/2,0]) cube([100+6+16,100+6+16,lgbreite]);
    }
    translate([0,-(100+6)/2,0]) cube([(100+6)/2+8,100+6,36]);
    
}

module absaug_sub() {
    cylinder(d=100,h=36);
    translate([-(100+6+16)/2,-(100+6+16)/2,lamelle]) cube([8,100+6+16,holz]);
    translate([-(100+6+16)/2,-(100+6+16)/2,lamelle]) cube([100+6+16,8,holz]);
    translate([-(100+6+16)/2,(100+6+16)/2-8,lamelle]) cube([100+6+16,8,holz]);

translate([53,20,18]) rotate([0,-90,0]) schraube();
translate([53,-20,18]) rotate([0,-90,0]) schraube();
translate([-52,0,18]) rotate([0,-90,0]) schraube();
translate([0,-52,18]) rotate([0,-90,90]) schraube();
translate([0,52,18]) rotate([0,-90,-90]) schraube();
    
}

module absaug() {
difference() {
    absaug_add(); absaug_sub();
}

}

module absaug_support() {
difference() {
   hull() {
      translate([60,-70,0]) cube([0.1,140,30]);
      translate([25,-45,15]) sphere(15); 
      translate([25,45,15]) sphere(15); 
   }
   cylinder(d=338/PI,h=30);
translate([55,52,15]) rotate([0,-90,-30]) schraube();
translate([55,-52,15]) rotate([0,-90,30]) schraube();
}
}



