$fn=50;

// rotate von 37.5 über 35 zu 33
module Glied() {
difference() {
translate([200,-400,0]) import("center.STL");
translate([24.75,0,0]) rotate([-90,-33,0]) rotate_extrude(angle=95) translate([4,0]) square([3.5,25]);
}
difference() {
translate([5,0,0]) rotate([-90,-37.5,0]) rotate_extrude(angle=55) translate([4,0]) square([4,25]);
translate([8,3,-5]) cube([5,19,10]);
}

translate([24.705,0,0]) rotate([-90,0,0]) cylinder(d2=5.3,d1=6.5,h=4.3);
translate([24.705,25,0]) rotate([90,0,0]) cylinder(d2=5.3,d1=6.5,h=4.3);
}


sensorlochabstand=19.5;
sensorloch=3.1; // zum Verschrauben
sensorrand=2;
sensorboden=3;

module sensorplatte() {
    translate([0,0,-sensorboden])
    difference() {
        union() {
           cube([sensorlochabstand+2*sensorrand+sensorloch,sensorloch+2*sensorrand,sensorboden]);
            translate([sensorrand+sensorloch/2,sensorrand+sensorloch/2,sensorboden]) cylinder(d1=sensorloch+2*sensorrand,d2=sensorloch+1,2);
            translate([sensorrand+sensorloch/2+sensorlochabstand,sensorrand+sensorloch/2,sensorboden]) cylinder(d1=sensorloch+2*sensorrand,d2=sensorloch+1,2);       
        }
        translate([sensorrand+sensorloch/2,sensorrand+sensorloch/2,0]) cylinder(d=sensorloch,sensorboden+2);
        translate([sensorrand+sensorloch/2+sensorlochabstand,sensorrand+sensorloch/2,0]) cylinder(d=sensorloch,sensorboden+2);
    }
}



halterh1=3;
halterh2=4;
wand=3;


module add(addglied=true,endstop=false) {
translate([-10,0,0])
  hull() {
    cube([94/2+10,6,halterh1]);
    cube([20,6+20,halterh2]);
  }
  
translate([1,0,0]) {  
translate([94/2-15,-wand,-25]) cube([15+wand,2*wand+6,25+halterh1]);
translate([94/2,-wand,-25]) cube([10+2*wand,2*wand+6,10+2*wand]);    
}

translate([-10,0,halterh2]) cube([2,6+20,10]);

if (addglied) translate([1,0,0]) {
translate([94/2-4.5,5,-4]) rotate([180,0,90]) Glied();
hull() {
translate([94/2+16,1.8,-11.5]) cube([4.5,15,15]);
translate([94/2+16,-wand,-25]) cube([4.5,2*wand+6,25+halterh1]);
}
translate([94/2-4.5,-wand,-11.5]) cube([4.5,15+wand+1.8,15]);
}

if (endstop) {
    mirror([1,0,0]) translate([-10,0,0])
    hull() {
    cube([94/2+10+3,6,halterh1]);
    cube([20,6+20,halterh2]);
  }

  translate([56.5,-3,3]) rotate([0,0,90]) sensorplatte();    
  mirror([1,0,0]) translate([56.5,-3,3]) rotate([0,0,90]) sensorplatte();    
     
}

}

module sub(addglied=true) {
translate([0,6+20/2,0]) cylinder(d=5.5,h=halterh2);
translate([0,0,-40]) cube([94/2,6,40]);    
translate([-10,3,halterh2+10/2]) rotate([0,90,0]) cylinder(d=3.2,h=3);
translate([-10,(6+20)/2,halterh2+10/2]) rotate([0,90,0]) cylinder(d=3.2,h=3);
translate([-10,(6+20)-3,halterh2+10/2]) rotate([0,90,0]) cylinder(d=3.2,h=3);

translate([1,0,0]) {
translate([94/2+wand-.15,0,-25-.15+wand]) cube([10.3,100,10.3]);    
translate([94/2+wand+1,-wand,-25+1+wand]) cube([8,wand,8]);    
if (addglied) translate([94/2,-wand,-10]) cube([16,24+wand,15]);
}
}

auflage=70;  //  70

module xadd() {
 translate([-23.5/2-6,-auflage/2,1]) cube([60,auflage,22]);
 translate([-23.5/2-6,-25/2,0]) cube([35.5+2,25,1]);
 translate([-23.5/2-6,-auflage/2,0]) cube([6,auflage,1]);
 //translate([-23.5/2-2-6,-auflage/2,-1]) cube([2,auflage,2]);
 translate([-23.5/2,-auflage/2,-1]) cube([2,auflage,2]);
 translate([-23.5/2,-25/2,-9]) cube([2,25,9]);
 translate([23.5/2,-auflage/2,0]) cube([6,auflage,1]);
 translate([23.5/2-2,-auflage/2,-1]) cube([2,auflage,2]);
 translate([23.5/2-2,-25/2,-1]) cube([2,25,2]);
 translate([23.5/2+6,-auflage/2,-1]) cube([2,auflage,2]);
 translate([23.5/2+6,-40/2,-9]) cube([2,40,9]);
 hull() {
  translate([-23.5/2,-10.15/2,-2.7-3.75/2]) rotate([0,-90,0]) cylinder(d=3.75,h=2);  
  translate([-23.5/2,-10.15/2,-2.7-3.75]) rotate([0,-90,0]) cylinder(d=3.75,h=2);   
  translate([-23.5/2-2,-10.15/2,-2.7-3.75]) rotate([0,-90,0]) cylinder(d=3.75,h=2);
 }
 hull() {
  translate([-23.5/2,10.15/2,-2.7-3.75/2]) rotate([0,-90,0]) cylinder(d=3.75,h=2);  
  translate([-23.5/2,10.15/2,-2.7-3.75]) rotate([0,-90,0]) cylinder(d=3.75,h=2);   
  translate([-23.5/2-2,10.15/2,-2.7-3.75]) rotate([0,-90,0]) cylinder(d=3.75,h=2);   
 }

 translate([94/2-3.5,27.5,-4+55]) rotate([0,0,-90]) Glied();

 translate([23.5/2+6+48.75-23,-40/2,18.5+25]) cube([25,40,1.5]);

 hull() {
     translate([23.5/2+6,-40/2,-9]) cube([12,3,25]);
     translate([23.5/2+6+48.75-23,-40/2,42+1.5]) cube([25,3,1.5]);
 }
 hull() {
     translate([23.5/2+6,40/2-3,-9]) cube([12,3,25]);
     translate([23.5/2+6+48.75-23,40/2-3,42+1.5]) cube([25,3,1.5]);
 }

  translate([23.5/2+6+48.75-23,-40/2,18.5+25+1.5]) cube([25,32,10]);

}

module xsub() {
  //cylinder(d=15,h=35);
  cube([19.5,23,10],center=true);  
  translate([-23.5/2-6+2,-auflage/2+2,1+22]) cube([60-2,auflage-4,2]);    
  translate([-23.5/2-6+2,-auflage/2+2,1+2]) cube([60-4,auflage-4,40]);    
  translate([-23.5/2-6+30,-auflage/2,1+22-17]) cube([3.5,3,17]);    
  translate([23,0,0]) cylinder(d=5,h=3);
  translate([23.5/2+6+2,-10.15/2,-2.7-4]) rotate([0,-90,0]) cylinder(d=3.3,h=2);  
  translate([23.5/2+6+2,10.15/2,-2.7-4]) rotate([0,-90,0]) cylinder(d=3.3,h=2);
  //translate([23.5/2,-10.15/2,-2.7-4]) rotate([0,-90,0]) cylinder(d=6.4,h=2,$fn=6);  
  //translate([23.5/2,10.15/2,-2.7-4]) rotate([0,-90,0]) cylinder(d=6.4,h=2,$fn=6);

  translate([23.5/2+6+48.75-23+4,-40/2,18.5+25+1.5]) cube([17,32,20]);
  hull() {
      translate([-20,-20,23]) rotate([0,90,0]) cylinder(d=5,h=5);
      translate([-20,-20,20.5]) rotate([0,90,0]) cylinder(d=5,h=5);
  }
  translate([-20,0,19]) rotate([0,90,0]) cylinder(d=5,h=5);
  translate([-23.5/2-6+1,-30,21]) rotate([0,90,0]) cylinder(d=3,h=5);
  translate([-23.5/2-6+1,30,21]) rotate([0,90,0]) cylinder(d=3,h=5);
}

module xtopadd() {
 translate([-23.5/2-6,-auflage/2,23]) cube([60,auflage,2]);

 hull() {
 translate([-23.5/2-6+8,-auflage/2+8,23+10]) sphere(d=10);
 translate([-23.5/2-6+8,auflage/2-8,23+10]) sphere(d=10);
 translate([30+23.5/2-8,-auflage/2+8,23+10]) sphere(d=10);
 translate([30+23.5/2-8,auflage/2-8,23+10]) sphere(d=10);
 translate([-23.5/2-6,-auflage/2,25]) cube([60-.2,auflage,.1]);
 }
 
 translate([-23.5/2-6+2,-30,21]) resize([2,0,0]) sphere(d=3);
 translate([-23.5/2-6+2,30,21]) resize([2,0,0]) sphere(d=3);
 translate([-23.5/2-6+2+.1,-30-3+.1,19.5]) cube([3,5,3.5]);   
 translate([-23.5/2-6+2+.1,30-5+3.1,19.5]) cube([3,5,3.5]);   
}

 

module xtopsub() {
 //translate([-23.5/2-6+5,-auflage/2+2,23]) cube([60-7,auflage-4,2]);

 hull() {
 translate([-23.5/2-6+5,-auflage/2+2,23]) cube([60-2-.2-7,auflage-4,.1]);
 translate([-23.5/2-6+8+2,-auflage/2+8+2,23+10-2]) sphere(d=10);
 translate([-23.5/2-6+8+2,auflage/2-8-2,23+10-2]) sphere(d=10);
 translate([30+23.5/2-8-2,-auflage/2+8+2,23+10-2]) sphere(d=10);
 translate([30+23.5/2-8-2,auflage/2-8-2,23+10-2]) sphere(d=10);
 }
     translate([30+23.5/2-1.6,-40/2-.1,25]) cube([5,3.2,10]);
     translate([30+23.5/2-1.6,40/2-3-.1,25]) cube([5,3.2,10]);
translate([0,0,38-.4]) rotate([0,0,-90]) linear_extrude(height=0.4) text("Laser",size=15,valign="center",halign="center");
translate([20,0,38-.4]) rotate([0,0,-90]) linear_extrude(height=0.4) text("Acro",size=15,valign="center",halign="center");
    translate([-23.5/2-6,15,23]) cube([5,4,5]);
    translate([-23.5/2-6,-15,23]) cube([5,1.4,5]);
}

module lock(fuehrung=false) {
translate([4.5-.3,-8.5/2,0]) cube([15+.6,8.5,1.625]);
hull() {
translate([0,-5.3/2,0]) cube([4.5,5.3,.1]);
translate([0,-4.8/2,1.525]) cube([4.5,4.8,.1]);
}
hull() {
translate([4.5+15,-5.3/2,0]) cube([4.5,5.3,.1]);
translate([4.5+15,-4.8/2,1.525]) cube([4.5,4.8,.1]);
}
if (fuehrung) {
    hull() {
        translate([1.5,-4.8/2,1.625]) cube([5,4.8,1]);
        translate([1.5,-4.8/2,1.625+2.9]) cube([2,4.8,.1]);
    }
    hull() {
        translate([24-6.5,-4.8/2,1.625]) cube([5,4.8,1]);
        translate([24-6.5+3,-4.8/2,1.625+2.9]) cube([2,4.8,.1]);
    }
    
}
}

module y2add() {
  translate([-60/2,0,65]) cube([60,45,22]);  
  translate([-84/2,43,33.575]) cube([17,2,18.2]);  
  hull() {
      translate([-60/2,43,33.575]) cube([5,2,65-33.575]);  
      translate([-60/2,23,65]) cube([5,2,1]);  
  }
  translate([84/2-17,43,33.575]) cube([17,2,18.2]);  
  hull() {
      translate([60/2-5,43,33.575]) cube([5,2,65-33.575]);  
      translate([60/2-5,23,65]) cube([5,2,1]);  
  }

translate([-48,0,7.5+70]) rotate([0,0,0]) Glied();
translate([-60/2-4,0,71.5]) cube([15,25,10]);      

}


module y2sub() {
  translate([-60/2+2,2,67]) cube([60-4,45-4,20]);  
  translate([76.935/2,45,46.575]) rotate([90,0,0]) cylinder(d=3.3,h=2);  
  translate([76.935/2,45,46.575-8.425]) rotate([90,0,0]) cylinder(d=3.3,h=2);  
  translate([-76.935/2,45,46.575]) rotate([90,0,0]) cylinder(d=3.3,h=2);  
  translate([-76.935/2,45,46.575-8.425]) rotate([90,0,0]) cylinder(d=3.3,h=2);  

  translate([-60/2-5,4,71.5]) cube([60-4,17,20]);      
  translate([60/2-2,5,67+3]) cube([2,5.5,17]);
  translate([60/2-10,45/2-5,65]) cylinder(d=5,h=2);  
  translate([60/2-5,45,65+19]) rotate([90,0,0]) cylinder(d=3,h=2);  
  translate([-60/2+5,45,65+19]) rotate([90,0,0]) cylinder(d=3,h=2);  
  translate([60/2-5,3,65+19]) rotate([90,0,0]) cylinder(d=3,h=2);  
  translate([-60/2+5,3,65+19]) rotate([90,0,0]) cylinder(d=3,h=2);  

  translate([60/2-10,45-5,65]) cylinder(d=5,h=2);  
  translate([-60/2+10,45-5,65]) cylinder(d=5,h=2);  

}


module yhadd() {
    translate([0,0,7.5]) rotate([0,180,0]) Glied();
    hull() {
        translate([0,21,0]) cube([6+2*3,.1,15]);
        translate([0,53+23-.1,0]) cube([6+2*3,.1,20]);
    }
    translate([-20,0,0]) cube([40,25,1.5]);
    translate([-16.5,0,0]) cube([40,25,15]);
    translate([-15,53,0]) cube([15,23,3]);
}

module yhsub() {
    translate([3,53,0]) cube([6,25,50]);
    translate([-1,53+17.072,10.08]) rotate([0,90,0]) cylinder(d=5.5,h=15);
    translate([-25,4,1.5]) cube([50,17,20]);
    translate([-9,53+17.072,0]) rotate([0,0,0]) cylinder(d=5.5,h=15);
    translate([-6,53+6.072,0]) rotate([0,0,0]) cylinder(d=5.5,h=15);
    translate([-10,0,15-1.6]) rotate([0,0,90]) resize([0,8.7,0]) lock();
    translate([16,0,15-1.625]) rotate([0,0,90]) resize([0,8.7,0]) lock();
}


%difference() { y2add(); y2sub(); };


module y2deckelsub() {
  translate([-60/2,0,87]) cube([60,45,2]);  
  translate([-60/2+3,2+.1,82]) cube([4,2,5]);  
  translate([60/2-3-4,2+.1,82]) cube([4,2,5]);  
  translate([-60/2+3,41-.1,82]) cube([4,2,5]);  
  translate([60/2-3-4,41-.1,82]) cube([4,2,5]);  
 
  translate([60/2-5,44,65+19]) rotate([90,0,0]) cylinder(d=2.7,h=1);  
  translate([-60/2+5,44,65+19]) rotate([90,0,0]) cylinder(d=2.7,h=1);  
  translate([60/2-5,2,65+19]) resize([0,2,0]) sphere(d=2.8);  
  translate([-60/2+5,2,65+19]) resize([0,2,0]) sphere(d=2.8);  
 
}

y2deckelsub();


//difference() { yhadd(); yhsub(); };


//lock();
//ranslate([0,20,0]) lock(true);

//difference() { add(); sub(); }

//rotate([180,0,0])
//translate([0,100,0]) 
//difference() { xadd(); xsub(); }
//difference() { xtopadd(); xtopsub(); }

//translate([0,200,0]) rotate([0,0,180]) mirror([1,0,0]) difference() { add(false); sub(false); }

//translate([0,200,0]) 
//rotate([0,0,180]) mirror([1,0,0]) difference() { add(addglied=false,endstop=true); sub(addglied=false,endstop=true); }

