$fn=100;

sensorlochabstand=19.5;
sensorloch=3.1; // zum Verschrauben
sensorrand=2;
sensorboden=4;

module sensorplatte() {
    translate([0,0,-sensorboden])
    difference() {
        union() {
           cube([sensorlochabstand+2*sensorrand+sensorloch,sensorloch+2*sensorrand,sensorboden]);
            translate([sensorrand+sensorloch/2,sensorrand+sensorloch/2,sensorboden]) cylinder(d1=sensorloch+2*sensorrand,d2=sensorloch+1,2);
            translate([sensorrand+sensorloch/2+sensorlochabstand,sensorrand+sensorloch/2,sensorboden]) cylinder(d1=sensorloch+2*sensorrand,d2=sensorloch+1,2);       
        }
        translate([sensorrand+sensorloch/2,sensorrand+sensorloch/2,0]) cylinder(d=sensorloch,sensorboden+2);
        translate([sensorrand+sensorloch/2+sensorlochabstand,sensorrand+sensorloch/2,0]) cylinder(d=sensorloch,sensorboden+2);
    }
}

module xhalter() {
translate([-.5,0,0]) sensorplatte();

difference() {
    union() {
        translate([-.5,sensorloch+2*sensorrand,-12]) cube([6+3,14,12]);
        translate([-.5,sensorloch+2*sensorrand-2,-28]) cube([6+3,3+4,25]);
        translate([-.5,0,-28]) cube([6+3,3+4+sensorloch+2*sensorrand,12]);

        
    }
translate([1,sensorloch+2*sensorrand+2,-114]) cube([6,30,112]);
}

difference() {
    union() {
        translate([-2.5,0,-28]) cube([3.5,15.5+sensorloch+2*sensorrand,12]);
        translate([-1.7,sensorloch+2*sensorrand+4.8+2.2,-28]) cube([3,6.6,12]);
        
    }
translate([-2.7,sensorloch+2*sensorrand+4.7+7/2+2.2,-18-4.5]) rotate([0,90,0]) cylinder(d=7.2,h=2.9);
translate([-2.7,sensorloch+2*sensorrand+4.7+7/2+2.2,-18-4.5]) rotate([0,90,0]) cylinder(d=5.8,h=6);
translate([-2.7,sensorloch+2*sensorrand+4.8+2.2-1.75,-28]) cube([1,10.5,15.7]);
}
}

//rotate([90,0,0]) xhalter();
//rotate([-90,0,0]) mirror([0,1,0]) xhalter();

module zhalter() {
sensorplatte();
translate([sensorlochabstand-sensorloch,10.5,0]) sensorplatte();
hull() {
    translate([26.5,0,-4]) cube([.1,10.5,4]);
    translate([42.9,10.5,-4]) cube([.1,.1,4]);
}
difference() {
    union() {
        translate([23,7,-4]) cube([5.1,29+9,4]);
        translate([23+15,16,-4]) cube([5,29,4]);
        translate([23,25,-17]) cube([20,20,17]);
    }
    translate([23+10,25+10,-17]) cylinder(d=5.5,h=4);
    translate([23+10,25+10,-13]) cylinder(d=11,h=20);
}
}

//rotate([0,90,0]) zhalter();

halterh2=4;

module xfingeradd() {
   translate([-10+2.25,10+8+10,33]) cube([1.5,40-10,8]);
   translate([-12,10,halterh2+1]) cube([6,10+6,11]);
   hull() { 
   translate([-10+2.25,10+8+10,33]) cube([1.5,20-10,8]);
   translate([-12,10,halterh2+11.9]) cube([6,10+6,.1]);
   }
}

module xfingersub() {
    translate([-10,0,halterh2]) cube([2.1,6+20,10]);
    hull() {
        translate([-12,(6+20)/2,halterh2+10/2]) rotate([0,90,0]) cylinder(d=3.2,h=6);
        translate([-12,(6+20)-3,halterh2+10/2]) rotate([0,90,0]) cylinder(d=3.2,h=6);
    }
    
}

//difference() { xfingeradd(); xfingersub(); }
//mirror([1,0,0]) difference() { xfingeradd(); xfingersub(); }


module yfingeradd(auskragen=false) {
    if (auskragen) {
        translate([10,0,0]) rotate([0,90,0]) {
           translate([0,0,0]) cube([20,20,13]);
           translate([7,0,-2]) cube([6,20,2]);
        }
   
   hull() { 
    translate([.75-10,-10-15,58]) cube([1.5,10,8]);
    translate([10+7,-10-15,-7]) cube([6,10,7]);
   }
   translate([10+7,-15,-7]) cube([6,15,7]);
   translate([.75-10,-15,58]) cube([1.5,40+5,8]);
    }
    else
    {
      translate([0,0,0]) cube([20,20,4]);
      translate([7,0,-2]) cube([6,20,2]);   
   hull() { 
    translate([.75,0,58]) cube([1.5,20,8]);
    translate([0,0,0]) cube([8,10+6,.1]);
   }
   translate([.75,20,58]) cube([1.5,40-10,8]);
    }
    
}

module yfingersub(auskragen=false) {
    translate([auskragen?10:0,0,0]) rotate([0,auskragen?90:0,0]) {
    translate([10,10,-2]) cylinder(d=5.5,h=20);
    translate([10,10,4]) cylinder(d=11,h=20);
    translate([10,10,-2]) cylinder(d=11,h=2);
    }
}

//difference() { yfingeradd(); yfingersub(); }
//translate([-10,0,0]) mirror([1,0,0]) difference() { yfingeradd(true); yfingersub(true); }



module kugellager() {
d_kugellager=15+.7;
sab_kugellager=12;
rs_kugellager=1.7; // mit Spiel
staerke=7;
    cylinder(d=d_kugellager,h=staerke);
    for(i=[0:3]) rotate([0,0,i*90+45]) translate([sab_kugellager,0,0]) cylinder(r=rs_kugellager,h=staerke);
}


module zfinger() {
difference() {
hull() {
    translate([-7,-11,-2]) cube([18,22,2]);
    translate([5.5+10,-17-10-3+1,-3]) cube([8,3,2]);
    translate([5.5+10,-10-3+1,-3]) cube([8,3,3]);
}
translate([-75/2+25,0,-3]) kugellager();
}

hull() {
    translate([5.5+10,-17-10-3,15+7+8]) cube([8,1.,40]);
    translate([5.5+10,-17-10-3,-3]) cube([8,3,3]);
}

translate([5.5,-17-10-3,15+7+8+40-4]) cube([18,1.,6]);

hull() {
    translate([5.5,-10-3+1-2,25+7-5]) cube([8,1.,6]);
    translate([5.5,-10-3+1-2,-2]) cube([8,3,3]);
}
translate([5.5,-10-3+1-2,25+7+1]) cube([8,1.,10]);

%translate([5.5,-17-10-3,15+7]) cube([5,3,8]);
%translate([5.5,-10-3,25+7]) cube([5,3,8]);
}

zfinger();