/*
 * =====================================
 *   This is public Domain Code
 *   Contributed by: Gael Lafond
 *   30 November 2018
 * =====================================
 *
 * Open Source Hardware pendant.
 *
 * Logo source:
 *     https://upload.wikimedia.org/wikipedia/commons/f/fd/Open-source-hardware-logo.svg
 *
 * SVG to OpenSCAD library:
 *     https://www.thingiverse.com/thing:2805184
 * 
 *
 * Values are in millimetres.
 */

hook_dia = 6;
hook_wall = 1;
thickness = 3;

linear_extrude(thickness) {
	hook_inner_dia = hook_dia - 2*hook_wall;

	// Hook
	translate([0, hook_inner_dia/2]) {
		difference() {
			circle(d = hook_dia, $fn = 50);
			circle(d = hook_inner_dia, $fn = 50);
		}
	}

	// Open Source Hardware logo
	// Source: https://upload.wikimedia.org/wikipedia/commons/f/fd/Open-source-hardware-logo.svg
	scale([0.3, 0.3]) {
		translate([-66.944, 0]) {
			bezier_polygon([[[133.161, -57.604], [133.161, -57.604], [116.72200000000001, -54.547], [116.72200000000001, -54.547]], [[116.72200000000001, -54.547], [116.322, -54.471999999999994], [115.88400000000001, -54.096], [115.74900000000001, -53.709999999999994]], [[115.74900000000001, -53.709999999999994], [115.74900000000001, -53.709999999999994], [110.71, -41.954], [110.71, -41.954]], [[110.71, -41.954], [110.52199999999999, -41.591], [110.55799999999999, -41.021], [110.78999999999999, -40.683]], [[110.78999999999999, -40.683], [110.78999999999999, -40.683], [120.368, -26.723], [120.368, -26.723]], [[120.368, -26.723], [120.597, -26.387], [120.55199999999999, -25.875999999999998], [120.26299999999999, -25.587]], [[120.26299999999999, -25.587], [120.26299999999999, -25.587], [108.3, -13.624], [108.3, -13.624]], [[108.3, -13.624], [108.011, -13.335], [107.50099999999999, -13.288], [107.16499999999999, -13.519]], [[107.16499999999999, -13.519], [107.16499999999999, -13.519], [92.96, -23.267], [92.96, -23.267]], [[92.96, -23.267], [92.624, -23.498], [92.04799999999999, -23.538999999999998], [91.68299999999999, -23.358999999999998]], [[91.68299999999999, -23.358999999999998], [91.68299999999999, -23.358999999999998], [80.287, -18.694], [80.287, -18.694]], [[80.287, -18.694], [79.9, -18.566], [79.523, -18.133], [79.447, -17.732]], [[79.447, -17.732], [79.447, -17.732], [76.282, -0.729], [76.282, -0.729]], [[76.282, -0.729], [76.208, -0.328], [75.813, 0.0], [75.405, 0.0]], [[75.405, 0.0], [75.405, 0.0], [58.485, 0.0], [58.485, 0.0]], [[58.485, 0.0], [58.078, 0.0], [57.683, -0.328], [57.609, -0.729]], [[57.609, -0.729], [57.609, -0.729], [54.445, -17.732], [54.445, -17.732]], [[54.445, -17.732], [54.369, -18.133], [53.993, -18.566], [53.605, -18.694]], [[53.605, -18.694], [53.605, -18.694], [42.208, -23.358999999999998], [42.208, -23.358999999999998]], [[42.208, -23.358999999999998], [41.842, -23.538999999999998], [41.266, -23.497999999999998], [40.931, -23.267]], [[40.931, -23.267], [40.931, -23.267], [26.727, -13.519], [26.727, -13.519]], [[26.727, -13.519], [26.39, -13.288], [25.879, -13.335], [25.591, -13.624]], [[25.591, -13.624], [25.591, -13.624], [13.627, -25.587], [13.627, -25.587]], [[13.627, -25.587], [13.339, -25.876], [13.291, -26.387], [13.522, -26.723]], [[13.522, -26.723], [13.522, -26.723], [23.101, -40.683], [23.101, -40.683]], [[23.101, -40.683], [23.331, -41.021], [23.366999999999997, -41.591], [23.18, -41.954]], [[23.18, -41.954], [23.18, -41.954], [18.14, -53.71], [18.14, -53.71]], [[18.14, -53.71], [18.006, -54.096000000000004], [17.569, -54.472], [17.167, -54.547000000000004]], [[17.167, -54.547000000000004], [17.167, -54.547000000000004], [0.729, -57.604], [0.729, -57.604]], [[0.729, -57.604], [0.327, -57.68], [0.0, -58.074], [0.0, -58.482]], [[0.0, -58.482], [0.0, -58.482], [0.001, -75.401], [0.001, -75.401]], [[0.001, -75.401], [0.001, -75.809], [0.329, -76.206], [0.73, -76.279]], [[0.73, -76.279], [0.73, -76.279], [16.765, -79.26299999999999], [16.765, -79.26299999999999]], [[16.765, -79.26299999999999], [17.166, -79.33599999999998], [17.595, -79.71699999999998], [17.717, -80.106]], [[17.717, -80.106], [17.717, -80.106], [22.723, -92.61099999999999], [22.723, -92.61099999999999]], [[22.723, -92.61099999999999], [22.901999999999997, -92.978], [22.86, -93.55199999999999], [22.628, -93.88799999999999]], [[22.628, -93.88799999999999], [22.628, -93.88799999999999], [13.52, -107.16099999999999], [13.52, -107.16099999999999]], [[13.52, -107.16099999999999], [13.29, -107.49699999999999], [13.337, -108.00899999999999], [13.625, -108.29799999999999]], [[13.625, -108.29799999999999], [13.625, -108.29799999999999], [25.59, -120.26099999999998], [25.59, -120.26099999999998]], [[25.59, -120.26099999999998], [25.878, -120.54799999999999], [26.389, -120.59499999999998], [26.726, -120.36599999999999]], [[26.726, -120.36599999999999], [26.726, -120.36599999999999], [39.763999999999996, -111.41699999999999], [39.763999999999996, -111.41699999999999]], [[39.763999999999996, -111.41699999999999], [40.099999999999994, -111.18699999999998], [40.663, -111.16899999999998], [41.013999999999996, -111.37399999999998]], [[41.013999999999996, -111.37399999999998], [41.013999999999996, -111.37399999999998], [46.763999999999996, -114.44399999999997], [46.763999999999996, -114.44399999999997]], [[46.763999999999996, -114.44399999999997], [47.12799999999999, -114.62999999999998], [47.553, -114.47299999999997], [47.708999999999996, -114.09599999999998]], [[47.708999999999996, -114.09599999999998], [47.708999999999996, -114.09599999999998], [59.565, -85.449], [59.565, -85.449]], [[59.565, -85.449], [59.721999999999994, -85.072], [59.565, -84.591], [59.217, -84.378]], [[59.217, -84.378], [59.217, -84.378], [57.778, -83.497], [57.778, -83.497]], [[57.778, -83.497], [57.512, -83.335], [57.150999999999996, -83.056], [56.868, -82.8]], [[56.868, -82.8], [51.677, -79.476], [48.233000000000004, -73.661], [48.233000000000004, -67.039]], [[48.233000000000004, -67.039], [48.233000000000004, -56.705], [56.611000000000004, -48.328], [66.944, -48.328]], [[66.944, -48.328], [77.277, -48.328], [85.654, -56.705000000000005], [85.654, -67.039]], [[85.654, -67.039], [85.654, -73.661], [82.211, -79.476], [77.01899999999999, -82.8]], [[77.01899999999999, -82.8], [76.73799999999999, -83.056], [76.37599999999999, -83.335], [76.11099999999999, -83.497]], [[76.11099999999999, -83.497], [76.11099999999999, -83.497], [74.672, -84.378], [74.672, -84.378]], [[74.672, -84.378], [74.326, -84.591], [74.16799999999999, -85.072], [74.324, -85.449]], [[74.324, -85.449], [74.324, -85.449], [86.179, -114.097], [86.179, -114.097]], [[86.179, -114.097], [86.33500000000001, -114.47399999999999], [86.759, -114.63], [87.124, -114.445]], [[87.124, -114.445], [87.124, -114.445], [92.874, -111.375], [92.874, -111.375]], [[92.874, -111.375], [93.226, -111.17], [93.788, -111.187], [94.124, -111.418]], [[94.124, -111.418], [94.124, -111.418], [107.163, -120.367], [107.163, -120.367]], [[107.163, -120.367], [107.499, -120.596], [108.011, -120.549], [108.298, -120.262]], [[108.298, -120.262], [108.298, -120.262], [120.263, -108.299], [120.263, -108.299]], [[120.263, -108.299], [120.552, -108.01], [120.599, -107.498], [120.36800000000001, -107.162]], [[120.36800000000001, -107.162], [120.36800000000001, -107.162], [111.25900000000001, -93.88900000000001], [111.25900000000001, -93.88900000000001]], [[111.25900000000001, -93.88900000000001], [111.02900000000001, -93.55300000000001], [110.98600000000002, -92.97900000000001], [111.16500000000002, -92.61200000000001]], [[111.16500000000002, -92.61200000000001], [111.16500000000002, -92.61200000000001], [116.17100000000002, -80.10700000000001], [116.17100000000002, -80.10700000000001]], [[116.17100000000002, -80.10700000000001], [116.29400000000003, -79.71800000000002], [116.72000000000003, -79.33700000000002], [117.12200000000001, -79.26400000000001]], [[117.12200000000001, -79.26400000000001], [117.12200000000001, -79.26400000000001], [133.157, -76.28000000000002], [133.157, -76.28000000000002]], [[133.157, -76.28000000000002], [133.55700000000002, -76.20700000000002], [133.88600000000002, -75.81000000000002], [133.88600000000002, -75.40200000000002]], [[133.88600000000002, -75.40200000000002], [133.88600000000002, -75.40200000000002], [133.88800000000003, -58.48300000000002], [133.88800000000003, -58.48300000000002]], [[133.88800000000003, -58.48300000000002], [133.88900000000004, -58.07400000000002], [133.56100000000004, -57.68000000000002], [133.16100000000003, -57.60400000000002]], [[133.16100000000003, -57.60400000000002], [133.16100000000003, -57.60400000000002], [133.161, -57.604], [133.161, -57.604]]]);
		}
	}
}

/**
 * Stripped down version of "bezier_v2.scad".
 * For full version, see: https://www.thingiverse.com/thing:2170645
 */

function BEZ03(u) = pow((1-u), 3);
function BEZ13(u) = 3*u*(pow((1-u),2));
function BEZ23(u) = 3*(pow(u,2))*(1-u);
function BEZ33(u) = pow(u,3);

function bezier_2D_point(p0, p1, p2, p3, u) = [
	BEZ03(u)*p0[0]+BEZ13(u)*p1[0]+BEZ23(u)*p2[0]+BEZ33(u)*p3[0],
	BEZ03(u)*p0[1]+BEZ13(u)*p1[1]+BEZ23(u)*p2[1]+BEZ33(u)*p3[1]
];

function bezier_coordinates(points, steps) = [
	for (c = points)
		for (step = [0:steps])
			bezier_2D_point(c[0], c[1], c[2],c[3], step/steps)
];

module bezier_polygon(points) {
	steps = $fn <= 0 ? 30 : $fn;
	polygon(bezier_coordinates(points, steps));
}
