stud_width = 38.1; /* 1.5 inch (width of a 2x4)  */
anchor_depth = 40; /*  must be < depth of 2x4 */
roll_diameter = 41.5;
roll_radius = 40/2;
spindle_height = 254; /* about 10 inches */

spindle_wall_offset = 60;
base_thickness = 10;
dome_z_scale = 1.5;
anchor_width = 10;
anchor_height = 40 + base_thickness;
$fn = 128;

union(){
    cylinder(r = roll_radius, h = spindle_height - dome_z_scale*roll_radius);
    translate([0,0,spindle_height - dome_z_scale*roll_radius]){
        scale([1,1,dome_z_scale]){
            sphere(r = roll_radius);
        }
    }
}

intersection(){
    translate([0, roll_radius + spindle_wall_offset, 0]){
        scale([(stud_width + 2*anchor_width)/2 , 30 + roll_radius + spindle_wall_offset, 1]){
            cylinder(r = 1, h = base_thickness);
        }
    }
    translate([-(stud_width/2 + anchor_width), 0, 0]){
        cube([stud_width + 2*anchor_width, roll_radius + spindle_wall_offset, base_thickness]);
    }
}

screw_r = 2.5;

translate([ -(stud_width/2 + anchor_width), roll_radius + spindle_wall_offset, 0]){
    difference(){
        cube([stud_width + 2*anchor_width, anchor_depth, anchor_height]);
        union(){
            translate([anchor_width, 10, -1]){
                cube([stud_width, anchor_depth, anchor_height + 2]);
            }
            translate([ (stud_width/2 + anchor_width), 2*anchor_width, base_thickness + ( (anchor_height-base_thickness)/4)]){
                rotate([90, 0, 0]){
                    cylinder(r = screw_r, h = 4*anchor_width);
                }
            }
            translate([ (stud_width/2 + anchor_width), 2*anchor_width, base_thickness + 2*( (anchor_height-base_thickness)/3)]){
                rotate([90, 0, 0]){
                    cylinder(r = screw_r, h = 4*anchor_width);
                }
            }
        }
    }
}