/* Open SCAD Name.: t_rail_v2.scad
*  Copyright (c)..: 2017 www.DIY3DTech.com
*
*  Creation Date..: 12/18/2018
*  Description....: maker-rail T bracket
*
*  Rev 1: Develop Model
*  Rev 2: 
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*/ 

/*------------------Customizer View-------------------*/

// preview[view:north, tilt:top]

/*---------------------Parameters---------------------*/

bolt_dia        =   5;  //bolt dia in mmm
radius_sz       =   18; //radius to match rail in mm
inside_h        =   6;  //heights of inside in mm
outside_h       =   8;  //height of outside in mm  
edge_offset     =   2;  //offset of edge in mm

/*-----------------------Execute----------------------*/

main_module();

/*-----------------------Modules----------------------*/

module main_module(){ //create module
    difference() {
            union() {//start union
              
              //create outside lip  
              translate ([0,0,0]) outside_module(outside_h,edge_offset);
              //create inside body
              translate ([0,0,0]) linear_extrude(height = inside_h, twist = 0, slices = 60)  base_module(radius_sz);
                
                
                        
                    } //end union
                            
    //start subtraction of difference
               
                    //create bolt holes
                    translate ([radius_sz,0,2]) rotate ([0,0,0]) cylinder(10,bolt_dia/2,bolt_dia/2,$fn=60,true);
                    translate ([0,0,2]) rotate ([0,0,0]) cylinder(10,bolt_dia/2,bolt_dia/2,$fn=60,true);
                    translate ([-radius_sz,0,2]) rotate ([0,0,0]) cylinder(10,bolt_dia/2,bolt_dia/2,$fn=60,true);
                    translate ([0,radius_sz,2]) rotate ([0,0,0]) cylinder(10,bolt_dia/2,bolt_dia/2,$fn=60,true);
                    translate ([0,radius_sz*2,2]) rotate ([0,0,0]) cylinder(10,bolt_dia/2,bolt_dia/2,$fn=60,true);
            
                    
                //base_module();
                                               
    } //end difference
}//end module

module outside_module(out_h,edge_o){ //create outer shape by difference
    difference() {
            union() {//start union
                
              translate ([0,0,0]) linear_extrude(height = out_h, twist = 0, slices = 60)  base_module(radius_sz);
  
                    } //end union
                            
    //start subtraction of difference
             translate ([0,0,-1]) linear_extrude(height = out_h+2, twist = 0, slices = 60) offset(r = -edge_o) base_module(radius_sz);
                    
                //base_module();
                                               
    } //end difference
}//end module

module base_module(rd_sz){ //create base shape
    
    //create bottom structure
                translate ([rd_sz,0,0]) rotate ([0,0,0]) circle(rd_sz/2,$fn=60,true);
                translate ([-rd_sz,0,0]) rotate ([0,0,0]) circle(rd_sz/2,$fn=60,true);
                translate ([0,0,0]) rotate ([0,0,0]) square([rd_sz*2,rd_sz],true);
               
                //create top strucutre
                translate ([0,rd_sz,0]) rotate ([0,0,0]) circle(rd_sz/2,$fn=60,true);
                translate ([0,rd_sz*2,0]) rotate ([0,0,0]) circle(rd_sz/2,$fn=60,true);
                translate ([0,rd_sz,0]) rotate ([0,0,0]) square([rd_sz,rd_sz*2],true);
}//end module
                 
/*----------------------End Code----------------------*/
