/* Configurable mast foot. By df5wc. */

/* Diameter of the mast that is placed into the foot. */
mast_dia = 68.0;

/* Number of base plate edges. */
edges = 6;

/* Diameter of the base plate. */
plate_dia = 150;

/* Height of the base plate. */
plate_height = 10.0;

/* Height of the foot. */
foot_height = 45.0;

/* Lower width of the foot. */
foot_lower = 20.0;

/* Upper width of the foot. */
foot_upper = 10.0;

/* Diameter of the peg holes. */
peg_dia = 10;

/* Hidden */
eps = 0.001;
$fn = 200;

/* Edge rounding factor. Must be smaller than plate height. */
rounding = 3;


module cylinder_outer(height, radius, fn = $fn) {
    fudge = 1/cos(180/fn);
    cylinder(h=height,r=radius*fudge,$fn=fn);
}

module plate(r, h, edges) {
    difference() {
        translate([0, 0, h/2]) {
            hull() {
                rotate_extrude(angle = 360, start = 0, $fn = edges) {
                    translate([r-h/2, 0, 0]) {
                        offset(r = rounding/2, $fn = 200) {
                            square([h-rounding, h-rounding], center = true);
                        }
                    }
                }
            }
        }
        // Peg holes
        for (angle = [0:360/edges:360]) {
            rotate([0, 0, angle]) {
                translate([r-peg_dia, 0, -eps]) {
                    cylinder_outer(h + 2*eps, peg_dia/2);
                }
            }
        }
        // Mid hole
        translate([0, 0, -eps]) {
            cylinder_outer(h + 2*eps, 10);
        }
    }
}

module foot(r, h) {
    translate([0, 0, rounding/2]) {
        rotate_extrude($fn = 200) {
            translate([r+rounding/2, 0, 0]) {
                offset(r = rounding/2, $fn = 200) {
                    polygon([
                        [0, 0],
                        [0, h-rounding],
                        [foot_upper-rounding, h-rounding],
                        [foot_lower-rounding, 0],
                        [0, 0]
                    ]);
                }
            }
        }
    }
}

module mastfoot(dia, hplate, hfoot, edges) {
    rplate = plate_dia/2 + 20 + 15 + rounding;
    union() {
        plate(plate_dia/2, plate_height, edges);
        translate([0, 0, plate_height - rounding]) {
            foot(dia/2, foot_height + rounding);
        }
    }
}

mastfoot(mast_dia, plate_height, foot_height, edges);
