//-------------------------------------------------
// Shapes2dTest
//-------------------------------------------------

include <Shapes2d.scad>

//------------------------------------------------
// test code
all = true;
echo ("Test_shapes all=", all);
base = 20;
height = 10;
yShift = max (base+2, height+2);
center = false;
thickness = 5;

//-------------------------------------------------
// draw points and lines
if (1)
{
	echo ("draw points and lines");
	
	pts=[[0,0],[10,0],[13,5],[3,5]];
	if (1)
	{
		echo ("show points");
		drawpts2d (pts);
	}
	if (1)
	{
		echo ("show lines");
		drawlines2d (pts, 0.5);
	}
}

//-------------------------------------------------
// triangles
if (0 || all)
{
	echo ("triangles");
	shift = [base+2, all ? 1*yShift : 0];
	
	if (1)
	{
		color ("green")
		translate ([0*shift.x, shift.y, 0])
		triangle_right (base, height, 
						thickness, center);
	}
	if (1)
	{
		color ("red")
		translate ([1*shift.x, shift.y, 0])
		triangle_isosceles (base, height, 
							thickness, center);
	}
	if (1)
	{
		color ("pink")
		translate ([2*shift.x, shift.y, 0])
		triangle_equilateral (base, 
							thickness, center);
	}
}

//-------------------------------------------------
// quadrilaterals
if (0 || all)
{
	echo ("quadrilaterals");
	shift = [base+2, all ? 2*yShift : 0];
	if (1)
	{
		color ("green")
		translate ([0*shift.x, shift.y, 0])
		parallelogram (0.75*base, height, 45, 
							thickness, center);
	}
	if (1)
	{
		color ("red")
		translate ([1*shift.x, shift.y, 0])
		isosceles_trapezoid (base, base/2, height, 
							thickness, center);
	}
	if (1 || all)
	{
		color ("blue")
		translate ([2*shift.x, shift.y, 0])
		rhombus (base, height, thickness, center);
	}
	if (1 || all)
	{
		color ("orange")
		translate ([3*shift.x, shift.y, 0])
		kite (base/2, height/3, height/2, 
				thickness, center);
	}
}
	
//-------------------------------------------------
// pentagons
if (0 || all)
{
	echo ("pentagons");
	side = 10;
	shift = [base+2, all ? 3*yShift : 0];
	
	if (1)
	{
		color ("green")
		translate ([0*shift.x, shift.y, 0])
		pentagon_cyclic_radius (side, 
								thickness, center);
	}
	if (1)
	{
		color ("blue")
		translate ([1*shift.x, shift.y, 0])
		pentagon_cyclic_side (side, 
								thickness, center);
	}
	if (1)
	{
		color ("red")
		translate ([2*shift.x, shift.y, 0])
		pentagon_convex (side, side, 1.5*side, 
							thickness, center);
	}
	if (1)
	{
		color ("pink")
		translate ([3*shift.x, shift.y, 0])
		pentagon_convex (side, side, 0.5*side, 
						thickness, center);
	}
}
	
//-------------------------------------------------
// stars
if (0 || all)
{
	side = 10;
	shift = [base+2, all ? 4*yShift : 0];
	
	if (1)
	{
		color ("green")
		translate ([0*shift.x, shift.y, 0])
		star_side (side, false, thickness, center);
	}
	if (1)
	{
		color ("blue")
		translate ([1*shift.x, shift.y, 0])
		star_side (side, true, thickness, center);
	}
}

//-------------------------------------------------
// test heart
if (1 || all)
{
	$fn = 15;
	shift = [base+2, all ? 5*yShift : 0];
	
	translate ([0*shift.x, shift.y, 0])
	heart2d (5, thickness, center);
}
