include <BOSL2/std.scad>

$fn = $preview ? 32 : 64;

crenel_count = 8;
base_height = 5;
base_thickness = 5;
platform_height = 4;
merlon_height = 4;
crenel_width = 5;
base_radius = 14;
inner_radius = 14.25;
outer_radius = 17;
texture_depth=.5;
brick_height=2.5;
brick_width=5;
brick_roughness=0.1;
transition_height = -1;
base_cutout=false;

epsilon = .01;

taper_height = transition_height >= 0
    ? transition_height
    : (outer_radius - base_radius)/3;
height = base_height + taper_height + platform_height + merlon_height;

tex = texture("bricks", roughness=brick_roughness);

module top() {
    diff()
    cyl(h=platform_height + merlon_height,
            r=outer_radius - texture_depth,
            texture=tex,
            tex_depth=texture_depth,
            tex_size=[brick_width,brick_height * 2]) {
        attach(TOP, TOP, inside=true)
            cyl(h=merlon_height, r=inner_radius, center=false);
        attach(TOP, TOP, inside=true)
            cyl(h=1, r1=inner_radius, r2=inner_radius + 1, center=false);
        for( deg = [0:360/crenel_count:360] ) {
            attach([sin(deg), cos(deg), 0], RIGHT, inside=true,
                    align=TOP, overlap=texture_depth, inset=-epsilon)
                cuboid([outer_radius, crenel_width, merlon_height+epsilon]);
        }
    }
}

module base(anchor=CENTER, spin=0, orient=UP) {
    attachable(anchor=anchor, spin=spin, orient=orient, r=base_radius, h=base_height) {
        diff()
            cyl(h=base_height, r=base_radius - texture_depth,
                texture=tex, tex_depth=texture_depth,
                tex_size=[brick_width, brick_height*2]) {
                if( base_cutout ) {
                    attach(BOTTOM, BOTTOM, inside=true)
                        cyl(h=base_height, r1=base_radius - base_thickness,
                                r2=max(0, base_radius-base_thickness-base_height));
                }
            }
        children();
    }
}

base(anchor=BOTTOM) {
    if( taper_height > 0 ) {
        attach(TOP, BOTTOM)
            cyl(h=taper_height,
                r1=base_radius-texture_depth,
                r2=outer_radius-texture_depth) {
                attach(TOP, BOTTOM)
                    top();
            }
    } else {
        attach(TOP, BOTTOM)
            top();
    }
}
