font = "Liberation Mono:style=Bold";
Version="V1";

$fn=64;

B=240;
H=230;
T=20;

Brett=18;

Wall1=5;
Wall2=4;

module rounded_bottom_box(w, l, h, r) 
{
	inner_length = l - 2 * r;
	inner_width = w - 2 * r;
	inner_height = h - r;
	
	hull() {
		translate([-inner_width / 2, -inner_length/2, r]) cylinder(r=r, h=inner_height);
		translate([inner_width / 2, -inner_length/2, r]) cylinder(r=r, h=inner_height);
		translate([inner_width / 2, inner_length/2, r]) cylinder(r=r, h=inner_height);
		translate([-inner_width / 2, inner_length/2, r]) cylinder(r=r, h=inner_height);
		
		translate([-inner_width / 2, -inner_length/2, r]) sphere(r=r);
		translate([inner_width / 2, -inner_length/2, r]) sphere(r=r);
		translate([inner_width / 2, inner_length/2, r]) sphere(r=r);
		translate([-inner_width / 2, inner_length/2, r]) sphere(r=r);
	}
}

module Wabe(x,y, StartX, StartY, DD)
{
    translate([Wall1+DD/2+x*DD+Wall1+StartX,StartY-y*DD+Wall1,-0.1]) rotate([0,0,30])
                cylinder(d=DD,h=T+0.2, $fn=6);

}

difference()
{
    // Base plate
    cube([B,H,T]);
    // Nute fuers Brett
    translate([-0.1,H-Wall2-Brett,Wall2]) cube([B+0.2,Brett,T]);
    // Ausbuchtung
    translate([20,20,Wall1])cube([B-20*2,H-20*4,T]);
    
    // Muster Unten
    UWD=110;
    translate([B/2,0,-0.1]) cylinder(d=UWD,h=T+0.2, $fn=6);
    // Muster Innen
    DD=27.5;
    StartY=H-Brett-Wall1-DD/2-Wall1*2-2;
    for(x=[0:1:7])
    {
        for(y=[0:2:4])
            Wabe(x,y,0,StartY,DD);
    }
    for(x=[0:1:6])
    {
        for(y=[1:2:4])
            Wabe(x,y,DD/2,StartY,DD);
    }
    Wabe(0,5,DD/2,StartY,DD);
    Wabe(1,5,DD/2,StartY,DD);
    Wabe(5,5,DD/2,StartY,DD);
    Wabe(6,5,DD/2,StartY,DD);
    Wabe(0,6,0,StartY,DD);
    Wabe(1,6,0,StartY,DD);
    Wabe(6,6,0,StartY,DD);
    Wabe(7,6,0,StartY,DD);
    // Screws
    d=3.5;
    Kd=7.1;
    for(xx=[0:1:3])
    {
        translate([30+B/4*xx,H-Wall2-Brett/2,-0.1]) cylinder(d=d, h=Wall2+0.15);
        // Head
        translate([30+B/4*xx,H-Wall2-Brett/2,-0.1]) cylinder(d2=d,d1=Kd,h=Wall2-1);
    }
    // Version
    translate([B/2,H-Wall2-Brett/2-4,Wall2-0.4]) linear_extrude(1) text(Version, font = font, size = 10);

}
