// Lampshade diffuser
// by GloomyTrousers
// Licence CC BY-SA-NC 4.0
// v1.4
// Latest version/instructions: https://www.gloomytrousers.co.uk/r/lampdiffuser

// __Config__

// Inner diameter of lampshade (mm)
shade_inner_diameter = 200;

// The width of the lip (mm) inside the shade (on which the diffuser sits)
shade_lip_width = 4;

// How many rings to include
num_rings = 6;

// How tall the rings are (mm)
ring_height = 24;

// Inward lean of the rings (mm difference between top and bottom)
ring_lean = 15;

// Thickness of the rings (mm)
ring_thickness = 1.2;

// Thickness of the arms (mm)
arm_thickness = 7.2;

// __End of config__

// Work out how far apart the rings will be
ring_spacing = (shade_inner_diameter-shade_lip_width-ring_thickness*4)/num_rings;

// Sanity checks
assert(ring_spacing > ring_thickness*5, "Rings too close together");
assert(num_rings >= 2, "Not enough rings");
assert(ring_lean >= 0, "Ring lean must be positive - vertical (0) or lean inwards");
assert(ring_lean <= ring_height, "Lean of rings must not be more than 45 degrees - won't print without support");
assert(arm_thickness <= ring_height, "Arms must not be thicker than ring height");

include <BOSL2/std.scad>

// The model
color("white")
    union() {
        // Arms
        rotate([0,0,45]) // Put the arms in the corners of the build plate, for slightly more room
            for(rot = [0:1]) {
                rotate([0,0,90*rot])
                    cuboid([arm_thickness,shade_inner_diameter,arm_thickness], rounding=arm_thickness/2, edges=[TOP+LEFT, TOP+RIGHT], anchor=BOT, $fa = 2, $fn = 30);
            }
        
        // Rings
        for(i = [1:num_rings]) {
            difference() {
                // Outer
                cylinder(h=ring_height, d1=ring_spacing*i+ring_thickness*2, d2=ring_spacing*i+ring_thickness*2-ring_lean*2, $fa = 2);
                // Cutout
                translate([0, 0, -0.1])
                    cylinder(h=ring_height+0.2, d1=ring_spacing*i, d2=ring_spacing*i-ring_lean*2, $fa = 2);
            }
        }
    }