// part: crank_axle
// description: Central axle with crank handle and drive key
// dims: 4mm dia shaft, 40mm total length
module part_crank_axle() {
    // Main axle shaft
    cylinder(h=17.9, d=4, $fn=32);
    
    // Drive key for strainer connection
    translate([-0.95, -2.3, 7.1])
        cube([1.9, 4.6, 10.8]);
    
    // Hex head for lid socket
    translate([0, 0, 17.9])
        cylinder(h=10, d=7.8/cos(30), $fn=6);
    
    // Crank arm
    translate([0, 0, 20.9])
        rotate([0, 90, 0])
            cylinder(h=25, d=3, $fn=24);
    
    // Crank handle
    translate([25, 0, 20.9])
        difference() {
            cylinder(h=12, d=8, $fn=32);
            translate([0, 0, 2])
                cylinder(h=9, d=5, $fn=32);
        }
}
part_crank_axle();