// part: lid
// description: Top lid with central crank mount
// dims: 62mm dia, 8mm height
module part_lid() {
    difference() {
        // Main lid body
        cylinder(h=8, d=64, $fn=64);
        
        // Internal lip recess to fit over bowl rim (bottom face)
        translate([0, 0, -0.5])
            cylinder(h=3, d1=62, d2=58, $fn=64);
        
        // Central hexagon hole for crank shaft
        translate([0, 0, -1])
            cylinder(h=17.9, d=6, $fn=32);
    }
}
part_lid();