// part: strainer_bowl
// description: Inner perforated bowl that spins
// dims: 54mm dia, 20mm height, drainage holes
module part_strainer_bowl() {
    difference() {
        // Main bowl structure
        cylinder(h=20, d=54, $fn=64);
        
        // Inner cavity
        translate([0, 0, 1.5])
            cylinder(h=19, d=51, $fn=64);
        
        // Drainage holes in bottom
        for(r = [8:4:24]) {
            for(a = [0:30:330]) {
                translate([r*cos(a), r*sin(a), -0.5])
                    cylinder(h=3, d=2.5, $fn=16);
            }
        }
        
        // Drainage holes in sides
        for(z = [3:3:18]) {
            for(a = [0:20:340]) {
                translate([25*cos(a), 25*sin(a), z])
                    rotate([0, 90, a])
                        cylinder(h=4, d=2.5, $fn=16);
            }
        }
    }
    
    // Central hub for axle connection
    difference() {
        cylinder(h=25, d=8, $fn=32);
        cylinder(h=26, d=4.2, $fn=32);
        
        // Keyway for drive connection
        translate([-1, -2.4, 15])
            cube([2, 4.8, 11]);
    }
}
part_strainer_bowl();