$fn = 64;

// ---------------- PARAMETERS ----------------
// Overall block size (these are now the *outer* dimensions)
block_x = 60;      // width  (X)
block_y = 60;      // depth  (Y)
block_z = 18;      // height (Z)

// Edge radius (rounds ALL 12 edges)
edge_r = 2;        // radius for all edges

// Cutout parameters
//X dimension of cutout
cutout_width = 57;//0.01 
cutout_height = 16;  // Z dimension of cutout
cutout_corner_r = 2; // corner radius for cutout

// Cable entry parameters
cable_slot_width = 20;    // width of rectangular slot

// L-hook parameters
hook_width = 8;           // total width of hook
 // width of cutout (creates the hook)
hook_cutout_width = 5;//.01   
// height of cutout from top 
hook_cutout_height = 5;//.01      
hook_spacing = 32;//.01        

hook_length = 50;         // length of hooks (centered, both ends reduce equally)

// ---------------- MODEL ----------------
difference() {
    rounded_block_all_edges(block_x, block_y, block_z, edge_r);
    
    // Cutout through the center (along Y axis)
    translate([0, 0, 0])
        rotate([90, 0, 0])
            linear_extrude(height = block_y + 10, center = true)
                offset(r = cutout_corner_r)
                    offset(r = -cutout_corner_r)
                        square([cutout_width, cutout_height], center = true);
    
    // Cable entry - rectangular slot through top
    translate([0, 0, block_z/2])
        linear_extrude(height = block_z + 1, center = true)
            square([cable_slot_width, block_y + 10], center = true);
}

// Add L-hooks on the base
union() {
    // Left hook (cutout on right side)
    translate([-hook_spacing/2, 0, -block_z/2])
        l_hook(hook_width, hook_cutout_width, hook_cutout_height, hook_length, false);
    
    // Right hook (cutout on left side - inverted)
    translate([hook_spacing/2, 0, -block_z/2])
        l_hook(hook_width, hook_cutout_width, hook_cutout_height, hook_length, true);
}

module rounded_block_all_edges(x, y, z, r) {
    // Minkowski rounds all edges by adding a sphere
    // Subtract 2*r from dimensions since minkowski adds the radius
    minkowski() {
        cube([x - 2*r, y - 2*r, z - 2*r], center = true);
        sphere(r = r);
    }
}

module l_hook(width, cutout_width, cutout_height, length, invert) {
    difference() {
        // Full rectangle with adjustable length (centered)
        translate([0, 0, -width/2])
            cube([width, length, width], center = true);
        
        // 5mm cutout (position depends on invert flag)
        translate([invert ? -cutout_width/2 : cutout_width/2, 0, -cutout_height/2])
            cube([cutout_width + 0.01, length + 1, cutout_height + 0.01], center = true);
    }
}