lightY = 38;
lightX1 = 30.2;
lightX2 = 26.7;
lightX3 = 28.5;
lightX1Y = 4.5;
lightX2Y = 14;
lightX3Y = lightY - lightX1Y - lightX2Y;

lightArcY1 = 10.5;
lightArcY2 = 26;
lightArcX = 60;
lightArcThick = 1;

tol = 0.5;
lightZ = 1170;

lightZDetentZ1 = 19;
lightZDetentZ2 = 21;
lightZDetentSize = lightZDetentZ2 - lightZDetentZ1;
lightZDetentWidth = 7;
lightZDetentHeight = 2;

lightSpan1 = 469;
lightSpan2 = 650;
lightSpanDiff = (lightSpan2 - lightSpan1) / 2;
lightAngle = asin(lightSpanDiff / lightZ);
lightSpanIncrements = 3;
lightArraySides = 4;

supportRingSpine = 15;
supportRingEndOffset = 50;
supportRingThick = 10;
ringWallThickness = 10;

lidDiameter = 307;

mountingChannelX = 10 + tol;
mountingChannelY = 4 + tol;
mountingChannelZ = 63 + tol;
mountingChannelY2 = 17 + tol;

bracketTopClearance = 30;
bracketThickness = 7;
bracketX = lightX1 + 2 * bracketThickness;
bracketY = lightY + 2 * bracketThickness;
bracketZ = supportRingEndOffset + bracketTopClearance + bracketThickness * 2;
bracketInset = 2 * bracketThickness + bracketTopClearance - 25;

screwHoleD = 3;
screwHoleL = 15;

moreStrutsWallThickness = 25;  

$fn = 360;

module hatBase() {
    translate([-15, 15, 0]) // center hat offset
        rotate([90, 0, 0])
            import("hat.stl", convexity=3);
}

module hatBaseMount() {
    intersection() {
        hatBase();
        translate([43.5, 0, 26.5])
            cube([20, 20, 50], center=true);
    }
}

module hatBaseModified() {
    union() {
        difference() {
            hatBase();
            translate([0, 0, 26.1])
                cube([200, 200, 20], center=true);
        }
        for(i = [0:1:3]) {
            rotate([0, 0, i * 90])
                translate([5, 0, 0])
                    hatBaseMount();
        }
    }
}

module screwHoles() { 
    for(i = [2:1:6]) {
        translate([0, 0, 3 - i * mountingChannelZ / 5])
            rotate([90, 0, 0])
                if(i != 5)
                    cylinder(h=screwHoleL, d=screwHoleD, center=true);
    }
}

module arm() {
    difference() {
        union() {
            translate([-43.5, 0, -26.5]) // move fulcrum to origin
                translate([31, -4.5, 47.5]) // move arm to matching location on hat
                    rotate([0, 90, 0])
                        import("arm.stl", convexity=1);
        }
        union() {
            translate([190, 0, -tol + mountingChannelZ/5 + bracketInset])
                rotate([0, 0, 90])
                    screwHoles();
        }
    }
}

module hat(angle=0) {
    translate([0, 0, -6 - bracketInset])
        union() {
            translate([43.5 + 5, 0, 26.5])
                rotate([90, 0, 0])
                    color("red") 
                        cylinder(h=20, d=3, center=true);
            
            for(i = [0:1:3]) {
                rotate([0, 0, i * 90])
                    translate([5, 0, 0]) // move to correct span for lights
                        translate([43.5, 0, 26.5]) // offset of mount holes from origin
                            rotate([0, angle, 0])
                                arm();
            }
            
            hatBaseModified();
        }
}

module bracket() {
    difference() {
        union() {
            cube([bracketX, bracketY, bracketZ], center=true);
        }
        union() {
            translate([0, -lightY/2, -lightZ - bracketZ/2 + supportRingEndOffset])
                light();
            
            translate([0, bracketThickness, 0 - bracketZ/2 + supportRingEndOffset + bracketTopClearance/2])
                cube([lightX2, lightY + bracketThickness, bracketTopClearance], center=true);
            
            translate([0, bracketThickness, 0 - bracketZ/2 + supportRingEndOffset/2])
                cube([lightX2, lightY + bracketThickness, bracketTopClearance], center=true);
            
            translate([0, -bracketY/2 + mountingChannelY/2, bracketZ/2 - mountingChannelZ/2 - 2*bracketThickness - bracketTopClearance + 25])
                cube([mountingChannelX, mountingChannelY, mountingChannelZ], center=true);
            
            translate([0, -bracketY/2 + mountingChannelY2/2, bracketZ/2 + mountingChannelZ/2 - bracketInset])
                cube([mountingChannelX, mountingChannelY2, mountingChannelZ], center=true);
            
            translate([0, -bracketY/2 + screwHoleL/2, bracketZ/2])
                screwHoles();
            
            translate([0, -bracketY/2 + bracketY*0.2, -bracketZ/2])
                cube([bracketX, bracketY*0.4, supportRingThick], center=true);
        }
    }
}

module supportRings() {
    expansionRate = (lightSpan2 - lightSpan1) / lightZ;
    initialExpansion = expansionRate * supportRingEndOffset;
    ringSpacing = (lightZ - 2 * supportRingEndOffset) / (lightSpanIncrements - 1);
    expansionPerRing = expansionRate * ringSpacing;
   
    
    difference() {
        union() {
            for(i = [0:1:lightSpanIncrements-1]) {
                ringZ = supportRingEndOffset + i * (lightZ - 2 * supportRingEndOffset) / (lightSpanIncrements - 1);
                
                translate([0, 0, ringZ]) {
                    linear_extrude(height=supportRingThick, center=true)
                        difference() {
                            // Outer boundary - natural hull of the lights
                            minkowski() {
                                hull()
                                    projection(cut=true)
                                        translate([0, 0, -ringZ])
                                            lightArray();
                                circle(r=supportRingSpine, $fn=8);
                            }
                            
                            // Inner boundary - shrink inward by wall thickness
                            offset(r=-ringWallThickness)
                                hull()
                                    projection(cut=true)
                                        translate([0, 0, -ringZ])
                                            lightArray();
                        }
                }
            }
        }
        union() {
            lightArray();
            translate([lightX1, lightX1, 0])
                cube(lightZ);
        }
    }
}

module lightProfile() {
    translate([0, lightY/2 + tol/2]) {
        minkowski() {
            difference() {
                union() {
                    square([lightX2, lightY], center=true);
                    translate([0, -lightY/2 + lightX1Y/2])
                        square([lightX1, lightX1Y], center=true);
                    translate([0, lightY/2 - lightX3Y/2])
                        square([lightX3, lightX3Y], center=true);
                    translate([0, -lightY/2 + lightArcY1/2 + lightArcY2 + (lightArcY1 - lightX1Y)])
                        scale([1, 1])
                            difference() {
                                circle(d=lightArcX);
                                circle(d=lightArcX - lightArcThick*2);
                            }
                }
                translate([0, lightY])
                    square([lightArcX, lightY], center=true);
            }
            square(tol);
        }
    }
}

module light() {
    color("blue", 0.6) {
        union() {
            linear_extrude(height=lightZ)
                lightProfile();
            translate([0, -lightZDetentHeight/2, lightZ - lightZDetentSize/2 - lightZDetentZ1])
                cube([lightZDetentWidth, lightZDetentHeight, lightZDetentSize], center=true);
        }
    }
}

module lightArray() {
    union() {
        for(i = [0:360/lightArraySides:360]) {
            rotate([0, 0, i]) {
                translate([0, -lightSpan1/2, lightZ]) {
                    rotate([-lightAngle, 0, 0]) {
                        translate([0, 0, -lightZ]) {
                            light();
                        }
                        translate([0, lightY/2, 0]) {
                            bracket();
                        }
                    }
                }
            }
        }
    }
}

module moreStruts() {
    difference() {
        translate([0, 0, 25])
            linear_extrude(height=10)
                difference() {
                    hull()
                        minkowski() {
                            projection(cut=false) {
                                intersection() {
                                    translate([0, 0, 35])
                                        cube([200, 200, 10], center=true);
                                    hat(-lightAngle);
                                }
                            }
                            circle(r=5, $fn=8);
                        }
                    
                    offset(r=-moreStrutsWallThickness)
                        hull()
                            minkowski() {
                                projection(cut=false) {
                                    intersection() {
                                        translate([0, 0, 35])
                                            cube([200, 200, 10], center=true);
                                        hat(-lightAngle);
                                    }
                                }
                                circle(r=5, $fn=8);
                            }
                }
        
        minkowski() {
            intersection() {
                translate([0, 0, 35])
                    cube([200, 200, 20], center=true);
                hat(-lightAngle);
            }
            cube(2 * tol);
        }
    }
}

//moreStruts();
// hatBaseModified();
// bracket();
//lightArray();
projection()
supportRings();
translate([0, 0, lightZ]) {
    //hat(-lightAngle);
    //moreStruts();
}
// arm();