hole_height=26.1;
hole_width=14;
a_bit=0.1;
thickness = 3;
between_clamps = 9.2;
thinness = 1.5;
small_part_offset = 7;
small_part_width = 14.2;

chop_off = (between_clamps + 2*thickness - small_part_width)/2;
echo(chop_off);

module clamp() {
  difference() {
    translate([-thickness, -thickness, 0])
      cube([hole_width+thickness, hole_height+2*thickness, thickness]);
    translate([0,0,-a_bit/2]) 
      cube([hole_width+a_bit, hole_height, thickness+a_bit]);
  }
}

module bracket() {
  clamp();
  translate ([0,0,between_clamps+thickness]) clamp();

  translate([-thickness, -thickness, 0]) {
      cube([thickness, hole_height+2*thickness, between_clamps+ 2*thickness]);
      cube([hole_width+thickness, thickness, between_clamps+ 2*thickness]);
  }

  translate([-thickness, hole_height, 0])
    cube([hole_width+thickness, thinness, between_clamps+2*thickness]);
}

difference() {
  bracket();

  translate([small_part_offset, hole_height-a_bit,-a_bit])
    cube([hole_width-small_part_offset+a_bit, thickness + 2*a_bit, chop_off+a_bit]);
  translate([small_part_offset, hole_height-a_bit, between_clamps+2*thickness-chop_off])
    cube([hole_width-small_part_offset+a_bit, thickness + 2*a_bit, chop_off+a_bit]);
}

difference() {
  translate([-thickness, hole_height/2,0])
    cylinder(between_clamps+2*thickness, d=hole_height+2*thickness);
  translate([0,-thickness-a_bit/2,-a_bit/2]) 
    cube([hole_width+a_bit, hole_height+2*thickness+a_bit, between_clamps+2*thickness+a_bit]);
}

