// Pole hole diameter
pole_diameter = 49.5;
// Ring thickness
thickness = 3.0; // [1:10]
// Ring height
height = 12;
// Number of tabs
num_tabs = 3; // [3:6]
// Tab base height (< height)
tab_base_height = 4;
// Tab thickness
tab_thickness = 5; // [2.0:10.0]
// Rope hole diameter
hole_diameter = 4; // [2.0:10.0]
// Text
text = "A1";
// Text size percent
text_size_pct = 50; // [20:80]

/* [Hidden] */
chamfer = 1;
glue = 0.01;
$fn = 150;

hole_radius = hole_diameter / 2;
eye_radius = hole_radius + tab_thickness;
pole_radius = pole_diameter / 2;

tabs_angle = 360 / num_tabs;

// text
color("grey")
intersection() {
    cylinder(h = height, r = pole_radius + thickness + 1, center = false);
    
    for(angle = [0: tabs_angle: 360 - tabs_angle])
    rotate([90, 0, 90 + 360 / num_tabs / 2 + angle])
    translate([0, height / 2, pole_radius])
    linear_extrude(height = thickness + 2, convexity = 10)
    text(text = text, size = height * text_size_pct / 100, halign = "center", valign = "center");
}

difference() {
    union() {
        // collar ring:
        extrude_chamfered(
            height = height,
            width = pole_diameter + thickness,
            chamfer = chamfer
        )
        circle(r = pole_radius + thickness);
       
       // tabs base:
        extrude_chamfered(
            height = tab_base_height,
            width = pole_diameter + thickness * 2 + eye_radius * 2,
            chamfer = chamfer,
            with_top = false
        )
        tab_base_2d();
        
        // tab buttress:
        translate([0, 0, tab_base_height])
        linear_extrude(
            height = height - tab_base_height - chamfer,
            scale = (pole_radius + thickness) / (pole_radius + thickness + hole_radius + eye_radius + chamfer)
        )
        tab_base_2d();
    }
    
    // cutout - rope holes:
    translate([0, 0, -glue])
    for(angle = [0: tabs_angle: 360 - tabs_angle])
        rotate([0, 0, angle])
        translate([pole_radius + thickness + hole_radius + chamfer, 0, 0])
        extrude_chamfered(height = height * 2, width = hole_diameter, chamfer = hole_diameter / 4, signum = 1)
        circle(d = hole_diameter);
    
    // cutout - pole hole:
    translate([0, 0, -glue])
    extrude_chamfered(height = height + 2 * glue, width = pole_diameter, chamfer = chamfer, signum = 1)
    circle(d = pole_diameter);
}

module tab_base_2d() {
    for(angle = [0 : tabs_angle : 360 - tabs_angle])
        hull() {
            circle(pole_radius);
            rotate([0, 0, angle])
            translate([pole_radius + thickness + hole_radius + chamfer, 0, 0])
                circle(eye_radius);
        }
}

module extrude_chamfered(height, width, chamfer, signum = -1, with_top = true) {
    union() {
        translate([0, 0, chamfer - glue])
        linear_extrude(height = height - (with_top ? 2 : 1) * ( chamfer - glue))
        children();
            
        chamfer_scale = (width + sign(signum) * chamfer * 2) / width;
        if (with_top) {
            translate([0, 0, height - chamfer])
            linear_extrude(height = chamfer, scale = chamfer_scale)
            children();
        }
        
        translate([0, 0, chamfer])
        mirror([0, 0, 1])
        linear_extrude(height = chamfer, scale = chamfer_scale)
        children();
    }
}