cap_type = 0; //[0:Triangle cap,1:Dome cap]
bottom_type = 0; //[0:Triangle cap,1:Dome cap]
fin_type=1;//[0:Box fins,1:Triangle fins]
total_height=10;//[2:25]
fin_count=3;//[3:20]
cap_ratio=0.1;//[0.1:0.05:0.5]
bottom_ratio=0.2;//[0.1:0.05:0.5]
resolution=10;//[5:50]
// im here to get the constants out of the customizer
module placeholder() {
    
}

cap_type_triangle=0;
cap_type_dome=1;

bottom_type_triangle=0;
bottom_type_dome=1;

fin_type_cube=0;
fin_type_triangle=1;
module atomic_bomb(total_height=10, width=1, cap_ratio=0.1, bottom_ratio=0.2, cap_type=cap_type_triangle, bottom_type=bottom_type_triangle, fin_type=fin_type_triangle, fin_width=0.25, fin_count=3) {
    body_ratio = 1-cap_ratio-bottom_ratio;
    body_height=total_height*body_ratio;
    body_offset=(bottom_ratio)*total_height;
    fin_rotation=360/fin_count;
    fin_rotation_2=140;
    union() {
        // body
        translate([0,0,body_offset])
        cylinder(body_height, width, width);
        // cap
        translate([0,0,body_height+body_offset])
        if (cap_type == cap_type_triangle)
            cylinder(total_height*cap_ratio, width, 0);
        else if (cap_type == cap_type_dome)
            scale([1,1,total_height*cap_ratio])
            intersection() {
                translate([0,0,total_height/2])
                cube([width*2, width*2, total_height], center=true);
                sphere(width);
            }
        // bottom
        
        if (bottom_type == bottom_type_triangle)
            cylinder(total_height*bottom_ratio, 0, width);
         else if (bottom_type == bottom_type_dome)
             translate([0,0,total_height*bottom_ratio])
             scale([1,1,total_height*bottom_ratio])
             sphere(width);
        // fins
        for(i = [0:fin_rotation:360]) {
            translate([0,0,total_height*bottom_ratio])

            rotate([0,0,i])
            rotate([0,fin_rotation_2,0])
            translate([-width/2,-(fin_width/2),width/2])
            // fin
            scale([1,1,total_height*bottom_ratio*1.5])
            if (fin_type==fin_type_cube)
                    cube([1,fin_width,1]);
            else if (fin_type==fin_type_triangle)
                intersection() {
                    cube([1,fin_width,2]);
                    rotate([0,20,0])

                    translate([0,0,-1])
                    cube([1,fin_width,2]);
                }
        }
        
    }
}



atomic_bomb(cap_type=cap_type, fin_type=fin_type, bottom_type=bottom_type, total_height=total_height, cap_ratio=cap_ratio, bottom_ratio=bottom_ratio, fin_count=fin_count, $fn=resolution);
