/*=================================================

  QNAP SP-X20-TRAY rails

  David Annett
  18 November 2025

  Simple rails to use with HDD as alternative to QNAP's SP-X20-TRAY.
  Test with TS-431P
  Should be compatable with TS-120/220/251/451/x31
  

=================================================*/

// Imported modules

include <3_5HDD.scad>;
showsample = false;

// Control rendering quality

$fa = 1;
$fs = 0.1;
ShowAll = true;
Overlap = 0.1;

// What to show

ShowTray       = false;
ShowTopRail    = true;
ShowBottomRail = true;
ShowNonPrint   = true;
ShowHDD        = true;
ShowScrews     = true;

// Major dimensions

QnapRailWidth       = 18.00; // Z axis
QnapBottomThickness =  1.50; // Z axis
QnapRailThickness   =  6.20; // X axis

// Derived dimemsions


// Helper modules

// Rails

module QnapRailLeft()
{
  difference () {
//    color("white", 0.5)
    translate([0, 0, 0])
    cube([QnapRailThickness, HDD35Length, QnapRailWidth]); 

    translate([QnapRailThickness, 0, QnapBottomThickness])
    HDD35SideScrewHoles(7, "Flat", 4, 2);

    translate([0.5, 93, 5])
    rotate([90, 0, -90])
    linear_extrude(0.6)
    text("Left/Top");
  }
}

module QnapRailRight()
{
  difference () {
//    color("white", 1)
    translate([HDD35Width + QnapRailThickness, 0, 0])
    cube([QnapRailThickness, HDD35Length, QnapRailWidth]); 

    translate([QnapRailThickness,
               0,
               QnapBottomThickness])
    HDD35SideScrewHoles(7, "Flat", 4, 2);

    translate([HDD35Width + QnapRailThickness*2 - 0.5,
               27, 5])
    rotate([90, 0, 90])
    linear_extrude(0.6)
    text("Right/Bottom");
  }
}

// Top (left) rail

if (ShowTopRail) {
  QnapRailLeft();
}

// Bottom (right) rail

if (ShowBottomRail) {
  QnapRailRight();
}

// Non-print parts

if (ShowHDD && ShowNonPrint) {
  color("gray", 0.5)
  translate([QnapRailThickness, 0, QnapBottomThickness])
  HDD35Model();
}

if (ShowScrews && ShowNonPrint) {
  color("blue", 1)
  translate([QnapRailThickness, 0, QnapBottomThickness])
  HDD35SideScrews(7, "Flat", 4);
}
