// Main spacer body dimensions
BODY_HEIGHT = 7.6;          // Body height/thickness
BODY_WIDTH = 23;            // Body width

// Tenon dimensions for mounting
TENON_WIDTH = 7.5;          // Tenon width
TENON_DEPTH = 8;            // Tenon depth

// Mounting screw parameters
SCREW_HOLE_X = 5.5;         // Screw hole X position
SCREW_HOLE_DEPTH = 20;      // Screw hole depth
SCREW_DIAMETER = 3.5;       // Screw hole diameter

// Endstop mounting hole positions
ENDSTOP_FRONT_OFFSET = 20.5;   // Offset from front edge
ENDSTOP_BACK_OFFSET = 7.5;     // Offset from back edge
ENDSTOP_HOLE_X1 = 11;          // First hole X position
ENDSTOP_HOLE_X2 = 20;          // Second hole X position
ENDSTOP_HOLE_DIAMETER = 2;     // Endstop hole diameter

// Adjustable offset between endstop holes
endstop_offset = 30;

// Calculated body depth
BODY_DEPTH = ENDSTOP_FRONT_OFFSET + endstop_offset + ENDSTOP_BACK_OFFSET;

// Nut dimensions and clearance
NUT_WIDTH = 5.35;           // Nut width side-to-side
NUT_HEIGHT = 2.35;          // Nut height
NUT_CLEARANCE = 0.15;       // Nut clearance for easy fit
NUT_POSITION_Y = 12;        // Nut position from top

module body_pos() {
    linear_extrude(BODY_HEIGHT) {
        difference() {
            square([BODY_WIDTH, BODY_DEPTH]);

            translate([0, BODY_DEPTH - TENON_DEPTH, 0])
                square([BODY_WIDTH - TENON_WIDTH, TENON_DEPTH]);

            for (x = [ENDSTOP_HOLE_X1, ENDSTOP_HOLE_X2])
                translate([x, ENDSTOP_BACK_OFFSET])
                    circle(d = ENDSTOP_HOLE_DIAMETER, $fn = 12);

            translate([SCREW_HOLE_X - NUT_WIDTH / 2 - NUT_CLEARANCE, BODY_DEPTH - NUT_POSITION_Y - NUT_HEIGHT - 2 * NUT_CLEARANCE])
                square([NUT_WIDTH + 2 * NUT_CLEARANCE, NUT_HEIGHT + 2 * NUT_CLEARANCE]);
        }
    }
}

module screw_neg() {
    translate([SCREW_HOLE_X, BODY_DEPTH - SCREW_HOLE_DEPTH, BODY_HEIGHT / 2])
        rotate([-90, 0, 0])
            cylinder(h = SCREW_HOLE_DEPTH, d = SCREW_DIAMETER, $fn = 12);
}

module endstop() {
    difference() {
        body_pos();
        screw_neg();
    }
}

endstop();
