fn=100;
$fn=fn;
BaseHeight=2.0;
BaseDiameter=90.0;
CenterRadius=25.0;

TopCylinderHeight=32;

SliceWidth=0.5;
SliceAngle=20;
SliceYoffset=7.50;
Vslice=0.75;

fillet=10;

module fillet()
{
//fillet variables;

FilletRadius=30;

rotate_extrude(convexity = 10, $fn = fn)
    translate([FilletRadius, 0, 0])
    difference(){
        circle(d = fillet, $fn = fn);
        translate([0, -fillet/2, 0])square([fillet,fillet],false);
        translate([-fillet/2, 0, 0])square([fillet,fillet],false);
        circle(d = fillet-4.0, $fn = fn);
    }
}


difference(){
  difference(){
    union(){
        difference(){
            cylinder(h=BaseHeight, d=BaseDiameter, center=false);
            translate([0,0,0])cylinder(h=BaseHeight+TopCylinderHeight, r=CenterRadius+fillet/2, center=false);
        }
        translate([0,0,fillet/2])mirror([0,0,0])fillet();
        translate([0,0,fillet/2])cylinder(h=TopCylinderHeight-fillet/2, r=CenterRadius+2, center=false);
        
    }  
}

    translate([0,0,fillet/2])cylinder(h=BaseHeight+TopCylinderHeight, r=CenterRadius, center=false);



union(){    //slice object in half
    translate([-BaseDiameter/2,-SliceYoffset,0])cube([BaseDiameter/2,SliceWidth,BaseHeight+Vslice],false); //vertical slice
        
    translate([-CenterRadius-2,-SliceYoffset,BaseHeight+0.5])rotate([-30,0,0])translate([-2,-0.1,0])cube([BaseHeight*10,SliceWidth,BaseDiameter/2],false); //slanted slice    
    
    translate([11,SliceYoffset,BaseHeight])rotate([30,0,0])translate([2,0,0.6])cube([BaseHeight*8,SliceWidth,BaseDiameter/2],false);  //slanted slice  

    translate([0,SliceYoffset-SliceWidth,0])cube([BaseDiameter/2,SliceWidth,BaseHeight+Vslice],false); //vertical slice
    }
}