/*[TOY GLASSES 4]*/
//eye center distance
Dis=65.0;
//center frame bias
V=10.0;
//center frame add length
L=5.0;
/*[CIRCULAR]*/
//daimeter
D=50.0;
Ang1=0.0;
Ang2=45.0;
//Frame 
//frame width
MW1=2.0;
//frame height
MH1=3.0;
//nose frame root height
MH21=4.0;
//nose frame tip height
MH2=8.0;
/*[MESH]*/
//mesh number along L(NI>=2)
NI=11;
//mesh number along W(NJ>=2)
NJ=11;
//mesh width
MW=1.6;
//mesh height
MH=1.6;
/* [Hidden] */
// Small finite distance to ensure proper meshing
eps = 0.01;
$fn=180;
DX=(D-MW)/(NI-1);
DY=(D-MW)/(NJ-1);
R=0.5*D;

module meshI(){
for(i=[1:NI]){
translate([(i-1)*DX,0,0])     
cube([MW,D,MH]);    
}
}

module meshJ(){
for(i=[1:NJ]){
translate([0,(i-1)*DY,0])     
cube([D,MW,MH]);    
}
}

module wall(){
translate([R,R,0]){
difference(){
cylinder(MH1,R,R);
translate([0,0,-eps])    
cylinder(MH1+2*eps,R-MW1,R-MW1);
}  
}
}
module cir(Ang){
translate([R,R,0])
rotate([0,0,Ang])
translate([-R,-R,0])
union(){
intersection() {
translate([R,R,0])
cylinder(MH1,R,R);    
union(){   
meshI();
meshJ();   
}
}
wall();
}
}

cir(Ang1);

translate([Dis,0,0])
cir(Ang2);


translate([(Dis-D)/2+MW1+D-MW1,R+V,0])
union(){

difference(){
cylinder(MH21,(Dis-D)/2+MW1,(Dis-D)/2+MW1);
union(){
translate([0,0,-eps])
cylinder(MH21+2*eps,(Dis-D)/2,(Dis-D)/2);
translate([-Dis/2,-Dis,-eps])
cube([Dis,Dis,MH21+2*eps]);
}
}
hull(){
translate([(Dis-D)/2+MW1/2,0,-eps])
cylinder(MH21,MW1/2,MW1/2);
translate([(Dis-D)/2+MW1/2,-L-R+MW/2,-eps])
cylinder(MH2,MW1/2,MW1/2);
}
hull(){
translate([-(Dis-D)/2-MW1/2,0,-eps])
cylinder(MH21,MW1/2,MW1/2);
translate([-(Dis-D)/2-MW1/2,-L-R+MW/2,-eps])
cylinder(MH2,MW1/2,MW1/2);
}

}