/*[Cast Net Disc]*/
/*[CIRCULAR]*/
//daimeter
D=400.0;
//height
H=25.0;
//width
MW=10.0;
//center daimeter
CD=60.0;

/*[fan]*/
//ratio
RR1=1.1;
//number of fans
numf=21;
//fan width
FW=6.0;
//mesh height
MH=20.0;
//directtion
idir=2;

/* [Hidden] */
// Small finite distance to ensure proper meshing
eps = 0.01;
$fn=180;
R=0.5*D;
H1=max(H,MH);
DA=360.0/numf;
RR=max(1.0,RR1);
R1=R*RR;

module wall(){
translate([R,R,0]){
difference(){
cylinder(H1,R,R);
translate([0,0,-eps])    
cylinder(H1+2*eps,R-MW,R-MW);
}  
}
}

union(){
intersection() {
translate([R,R,0])
cylinder(H1,R,R);    
union(){

translate([R,R,0]){
difference(){
cylinder(H1,CD,CD);
translate([0,0,-eps])
cylinder(H1+2*eps,CD-MW,CD-MW);
}



difference(){
for(i=[1:numf])
rotate([0,0,i*DA])
translate([0,R1/2,0])
difference(){
cylinder(MH,R1/2,R1/2);
union(){
translate([0,0,-eps])
cylinder(MH+2*eps,R1/2-FW,R1/2-FW);
if(idir==1){
translate([0,-R1/2,-eps])
cube([R1,R1,MH+2*eps]);
}
else if(idir==2){
translate([-R1,-R1/2,-eps])
cube([R1,R1,MH+2*eps]);

}
else{
}

}
}


translate([0,0,-eps])
cylinder(MH+2*eps,CD-MW,CD-MW);

}
}
 
}
}
wall();
}


