$Width=24;
$Height=42;
$Thickness=3;
$Gusset_Inset=3;
$Gusset_Height=2;
$Gusset_Thickness=2;
$Clip_Length=14;
$Clip_Height=3;
$Clip_Width=12;
$Center_Support_Height=5;
$fn=90;

module clip_pedistal() {
	cube([$Clip_Width, $Gusset_Thickness/2, $Gusset_Height], center = true);
}

module do_triangle(b, h, w) {
	linear_extrude(height = w, center = true, convexity = 10, twist = 0)
		polygon(points=[[0,0],[h,0],[0,b]], paths=[[0,1,2]]);
}

module da_triangle() {
	union() {
		translate(v=[0,-1.5, 1.5]) rotate(a=[90,90,90]) do_triangle(2,7,$Clip_Width);
		translate(v=[0,-1.5, 1.5])
			rotate(a=-90,v=[0,180,0]) do_triangle(2,7,$Clip_Width);
	}
}


module clip() {
	// just a triangle sitting apon the gusset
	union() {
		translate(v= [0,-1,7])  
			clip_pedistal();
		da_triangle();
	}
}

module basic_plate() {
		// Front Face
		cube([$Width, $Height, $Thickness], center = true);
		// Gusset Frame
		difference() {
			translate(v= [0, 0, $Gusset_Inset-1])  
				cube([$Width-$Gusset_Inset, $Height-$Gusset_Inset, $Gusset_Height], center = true);
			translate(v= [0, 0, $Gusset_Inset-1]) 
				cube([$Width-$Gusset_Inset-$Gusset_Thickness, $Height-$Gusset_Inset-$Gusset_Thickness, $Gusset_Height], center = true);
		}
		// Add the center support
		translate(v= [-($Height/42)+1, 0,$Gusset_Inset-1]) 
			cube([$Width-$Gusset_Inset-$Gusset_Thickness, $Gusset_Thickness, $Center_Support_Height], center = true);
}

module plate() {
	union() {

		// The basic plate
		basic_plate();
		// Add clips
		translate(v= [0, ($Height/2)-($Gusset_Inset/2)+0.5,($Gusset_Inset+$Thickness*2)+$Gusset_Height]) rotate(a=[0,180,0])
			clip();
		translate(v= [0, (-1*($Height/2))+($Gusset_Inset/2)-0.5,($Gusset_Inset+$Thickness*2)+$Gusset_Height]) rotate(a=[0,180,180])
			clip();
	}
}

module switch_plate() {
	difference() {

		plate();
		cylinder(r=8.0,h=10,center=true);
	}
}

function hole_distance(numHoles) = ((($Height-$Gusset_Inset-$Gusset_Thickness)/numHoles));
//function hole_loc(holeID, numHoles) = (($Height/numHoles) * (holeID))/numHoles;
function hole_loc(holeID, numHoles) = (($Height/numHoles) + hole_distance(numHoles));

module generic_mount_plate(holes=2, size=3) {
	difference() {
		plate();
		
		for (i = [1 : holes] ) {
			translate(v=[0,hole_loc(i, holes),0])			
				cylinder(r=size,h=10,center=true);
		}
	}
}

module mount_plate(holes=2, size=3) {
	difference() {
		plate();
		
		translate(v=[0,-hole_distance(2)*0.5,0])			
				cylinder(r=size,h=10,center=true);
		translate(v=[0,hole_distance(2)*0.5,0])			
				cylinder(r=size,h=10,center=true);
	}
}

//switch_plate();
mount_plate(2,3);

