global_fn = 100;
play = 0.5; // Amount of play in parts.
F = [
    0, 0.8, 1.6, 2.4, 3.2,
    4 ,5, 5.5, 6.5, 0,
    8, 0, 10, 0, 11,
    0, 13, 0, 15, 0,
    16, 0, 18, 0, 19
]; // Thickness or height of an M bolt.
S = [
    0, 2.5, 4.0, 5.5, 7,
    8, 10, 11, 13, 0,
    17, 0, 19, 0, 22,
    0, 24, 0, 27, 0,
    30, 0, 32, 0, 36
]; // Width across corners.

m_bolt_size = 8; // M-bolt size or thread diameter.
wall_thickness = 3; // Wall thickness.
outer_diameter = 27.0; // Outer diameter of the part.
part_height = 25.0; // Target height of the angled part.

wall_thickness_1 = max(wall_thickness, 0); // The wall thickness can not be negative.
part_height_1 = max(part_height, 0); // The angled part height can not be negative.
s_w = S[m_bolt_size] + play / 2; // The bolt diameter.
bottom_thickness_0 = max(wall_thickness_1 + 2, 0); // The floor should be a bit thicker than the walls.
outer_diameter_1 = max(
    outer_diameter, // Use outer diameter, if possible.
    s_w/sin(60) + 1, // The nut must fit into the bottom.
    m_bolt_size + 2 * (wall_thickness_1 + 1) + play // The bolt must fit through the middle.
) - play;
outer_radius = outer_diameter_1 / 2;
bottom_thickness = F[m_bolt_size] + bottom_thickness_0; // The part with the nut needs to encapsulate it without compromising the bottom's thickness.

// The angle of the slicing block.
angle = min(atan(part_height_1 / outer_diameter_1), 45);

// The slicing block's dimensions.
x=outer_diameter_1 * 4; // Big enough.
y=outer_diameter_1 + 2;
z=outer_diameter_1 * sin(angle);

// First half with the nut.
translate([outer_radius, 0, bottom_thickness]) {
    difference(){
        union(){
            difference(){
                cylinder(r=outer_radius,h=part_height_1,$fn=global_fn);
                translate([0,0,-2])
                cylinder(r=(outer_radius)-(wall_thickness_1),h=part_height_1 + 3,$fn=global_fn);
            }
        }
        translate([0,0,part_height_1]){
            rotate([0,angle,0])
            cube([x,y,z],center=true);
        }
    }

    // Bottom part with the nut.
    difference(){
        translate([0,0,-bottom_thickness]){
            cylinder(r=(outer_radius),h=bottom_thickness,$fn=global_fn);
        }
        union(){
            translate([0,0,-bottom_thickness  - 1]){
                cylinder(r=m_bolt_size / 2 + play / 2,h=bottom_thickness + 2,$fn=global_fn);
            }
            translate([0,0,-bottom_thickness - 1])
            cylinder(r=s_w/2/sin(60),h=1 + F[m_bolt_size], $fn=6);
        }
    }
}

// Second half with the slit.
rotate([0,0,180]) {
	translate([outer_radius + 3, 0, bottom_thickness_0]){
        // Bottom and the slit
		difference(){
			translate([0,0,-bottom_thickness_0])
			cylinder(r=outer_radius,h=bottom_thickness_0,$fn=global_fn);
			translate([0,0,-bottom_thickness_0 - 1]){
				hull(){
					translate([
                        (outer_radius - wall_thickness_1) - (max(bottom_thickness_0, wall_thickness_1, m_bolt_size / 2 + play / 2, 1)),
                        0,
                        0
                    ])
					cylinder(
                        r=m_bolt_size / 2 + play / 2,
                        h=bottom_thickness_0 + 2,
                        $fn=global_fn
                    );
					
                    
                    translate([
                        -(outer_radius - wall_thickness_1) + (max(bottom_thickness_0, wall_thickness_1, m_bolt_size / 2 + play / 2, 1)),
                        0,
                        0
                    ])
					cylinder(
                        r=m_bolt_size / 2 + play / 2,
                        h=bottom_thickness_0 + 2,
                        $fn=global_fn
                    );
				}
			}
		}
        // Top cone
		difference(){
            union(){
                difference(){
                    cylinder(r=outer_radius,h=part_height_1,$fn=global_fn);
                    translate([0,0,-2])
                    cylinder(r=(outer_radius)-(wall_thickness_1),h=part_height_1 + 3,$fn=global_fn);
                }
            }
            translate([0,0,part_height_1]){
                rotate([0,angle,0])
                cube([x,y,z],center=true);
            }
        }
	}
}











