$fn = 128;
outer = 38.5;
inner = 27.5;
outerHeight = 16.9;
holeDiameter = 12.2;
holeVerticalOffset = 4.4;
holeRadialOffset = 4.5;
centerHole = 5;
centerHoleOuter = 8.4;
centerHoleHeight = 7.1;
centerSquareSize = 5;
centerSquareHeight = 3.5;
centerDentHeight = 1;
centerDentDiameter = 11.4;

innerHeight = outerHeight - centerHoleHeight; // 12.8;

difference() {
    union() {
        difference() {
            cylinder(
                h = outerHeight,
                r1 = outer / 2,
                r2 = outer / 2
            );

            translate([0, 0, -1])
            cylinder(
                h = innerHeight + 1,
                r1 = inner / 2,
                r2 = inner / 2
            );
        }

        translate([0, 0, outerHeight - centerHoleHeight])
        cylinder(
            h = centerHoleHeight,
            r1 = centerHoleOuter / 2,
            r2 = centerHoleOuter / 2
        );
    }

    translate([0, 0, -1])
    cylinder(
        h = outerHeight + 2,
        r1 = centerHole / 2,
        r2 = centerHole / 2
    );
    
    translate([-centerSquareSize / 2, -centerSquareSize / 2, outerHeight - centerSquareHeight + 1])
    cube([
        centerSquareSize,
        centerSquareSize,
        centerSquareHeight
    ]);
    
    translate([0, 0, outerHeight - centerDentHeight])
    cylinder(
        h = centerDentHeight + 1,
        r1 = centerDentDiameter / 2,
        r2 = centerDentDiameter / 2
    );
    
    translate([
        outer / 2 - holeRadialOffset - holeDiameter / 2,
        outer / 2 + 1,
        outerHeight - holeVerticalOffset - holeDiameter / 2
    ])
    rotate([90, 0, 0])
    cylinder(
        h = outer + 2,
        r1 = holeDiameter / 2,
        r2 = holeDiameter / 2
    );
    
    translate([
        outer / 2 - holeRadialOffset - holeDiameter,
        outer / 2 + 1,
        outerHeight - holeVerticalOffset - 3/2 * holeDiameter
    ])
    rotate([90, 0, 0])
    cube([
       holeDiameter,
       holeDiameter,
       outer + 2
    ]);
}
/*
        */
