$fn = 64;

metalLipDepth = 17;
glassLipDepth = 5;
metalThickness = 2.5;
glassThickness = 5;
guideLengthX = 40;
guideLengthY = 40;
wallThickness = 2;
insertLength = 6;
insertDiameter = 4.75;
screwDiameter = 8;
isBackwallPiece = false;
isMirrored = false;
isSidePiece = true;
hasCornerInsert = false;

hasCornerInsertMod1 = hasCornerInsert || isSidePiece;
backwallMod1 = isBackwallPiece || isSidePiece ? 2 * wallThickness : 0;
backwallMod2 = isBackwallPiece || isSidePiece ? backwallMod1 + glassLipDepth : 0;
backwallMod3 = isBackwallPiece || isSidePiece ? 0 : glassLipDepth;
sidewallMod1 = isSidePiece ? (guideLengthY - metalLipDepth - wallThickness + 2) : -1;
sidewallMod2 = isSidePiece ? -1 : -metalLipDepth - wallThickness - 1;
screwRadius = max(screwDiameter / 2, insertDiameter / 2);

rotate([-90, 0, 0])
mirror([isMirrored && (isBackwallPiece || isSidePiece) ? 1 : 0, 0, 0]) {
    difference() {
        difference() {
            difference() {
                difference() {
                    union() {
                        
                        // The backplate.
                        cube([guideLengthX, 2 * wallThickness + metalThickness, guideLengthY]);
                        
                        // Glass lip wall
                        if (!(isBackwallPiece || isSidePiece)) {
                            translate([guideLengthX - wallThickness, -glassThickness, 0])
                            cube([wallThickness, glassThickness + 2 * wallThickness, guideLengthY]);
                        }
                        
                        // Glass lip roof
                        translate([0, -glassThickness, guideLengthY - 1 * wallThickness])
                        cube([guideLengthX, glassThickness + 2 * wallThickness, wallThickness]);
                        
                        // Glass lip
                        translate([0, -(glassThickness + wallThickness), 0])
                        cube([guideLengthX, wallThickness, guideLengthY]);
                        
                        if (hasCornerInsertMod1) {
                            // Insert embedding in the corner of the metal lip.
                            translate([
                                guideLengthX - (metalLipDepth + backwallMod3) / 2,
                                2 * wallThickness + metalThickness + insertLength,
                                guideLengthY - (metalLipDepth + glassLipDepth) / 2
                            ])
                            rotate([90, 0, 0])
                            cylinder(
                                wallThickness + insertLength,
                                insertDiameter / 2 + wallThickness,
                                insertDiameter / 2 + wallThickness + 2
                            );
                        }
                        
                        // Insert embedding in the top left of the metal lip.
                        translate([
                            2 * wallThickness + insertDiameter,
                            2 * wallThickness + metalThickness + insertLength,
                            guideLengthY - (metalLipDepth + glassLipDepth) / 2
                        ])
                        rotate([90, 0, 0])
                        cylinder(
                            wallThickness + insertLength,
                            insertDiameter / 2 + wallThickness,
                            insertDiameter / 2 + wallThickness + 2
                        );
                        
                        if (!isSidePiece) {
                            // Insert embedding in the bottom right of the metal lip.
                            translate([
                                guideLengthX - (metalLipDepth + backwallMod3) / 2,
                                2 * wallThickness + metalThickness + insertLength,
                                2 * wallThickness + insertDiameter
                            ])
                            rotate([90, 0, 0])
                            cylinder(
                                wallThickness + insertLength,
                                insertDiameter / 2 + wallThickness,
                                insertDiameter / 2 + wallThickness + 2
                            );
                        }
        
                    }
                    
                    // Remove excess from the glass lip.
                    translate([
                        -glassLipDepth - 1,
                        -wallThickness - glassThickness - 1,
                        -glassLipDepth - 1
                    ])
                    cube([
                        guideLengthX - wallThickness + 1 + backwallMod2,
                        wallThickness + glassThickness / 2 + 1,
                        guideLengthY - wallThickness + 1
                    ]);
                    
                }
                
                // Metal lip vertical slit.
                translate([guideLengthX - metalLipDepth, wallThickness, sidewallMod1])
                cube([metalLipDepth + 1, metalThickness, guideLengthY + 2]);
            }
            
            // Metal lip horizontal slit.
            translate([-1, wallThickness, guideLengthY - metalLipDepth])
            cube([guideLengthX + 2, metalThickness, metalLipDepth + 1]);
        }
        
        // Remove excess from the metal lip.
        translate([
            sidewallMod2,
            -1,
            -metalLipDepth - 1
        ])
        cube([
            guideLengthX + 2,
            2 * wallThickness + metalThickness + 2,
            guideLengthY - wallThickness + 1
        ]);
        
        if (hasCornerInsertMod1) {
            // Screwhole in the corner of the metal lip.
            translate([
                guideLengthX - (metalLipDepth + backwallMod3) / 2,
                wallThickness + metalThickness,
                guideLengthY - (metalLipDepth + glassLipDepth) / 2
            ])
            rotate([90, 0, 0])
            cylinder(wallThickness + metalThickness + 1, screwRadius, screwRadius);
        }
        
        // Screwhole in the top left part of the metal lip.
        translate([
            2 * wallThickness + insertDiameter,
            wallThickness + metalThickness,
            guideLengthY - (metalLipDepth + glassLipDepth) / 2
        ])
        rotate([90, 0, 0])
        cylinder(wallThickness + metalThickness + 1, screwRadius, screwRadius);
        
        if (!isSidePiece) {
            // Screwhole in the bottom right part of the metal lip.
            translate([
                guideLengthX - (metalLipDepth + backwallMod3) / 2,
                wallThickness + metalThickness,
                2 * wallThickness + insertDiameter
            ])
            rotate([90, 0, 0])
            cylinder(wallThickness + metalThickness + 1, screwRadius, screwRadius);
        }
        
        if (hasCornerInsertMod1) {
            // Insert embedding hole in the corner of the metal lip.
            translate([
                guideLengthX - (metalLipDepth + backwallMod3) / 2,
                metalThickness + insertLength,
                guideLengthY - (metalLipDepth + glassLipDepth) / 2
            ])
            rotate([90, 0, 0])
            cylinder(
                insertLength + metalThickness / 2,
                insertDiameter / 2,
                insertDiameter / 2
            );
        }
        
        // Insert embedding hole in the top left of the metal lip.
        translate([
            2 * wallThickness + insertDiameter,
            metalThickness + insertLength,
            guideLengthY - (metalLipDepth + glassLipDepth) / 2
        ])
        rotate([90, 0, 0])
        cylinder(
            insertLength + metalThickness / 2,
            insertDiameter / 2,
            insertDiameter / 2
        );
        
        if (!isSidePiece) {
            // Insert embedding hole in the bottom right of the metal lip.
            translate([
                guideLengthX - (metalLipDepth + backwallMod3) / 2,
                metalThickness + insertLength,
                2 * wallThickness + insertDiameter
            ])
            rotate([90, 0, 0])
            cylinder(
                insertLength + metalThickness / 2,
                insertDiameter / 2,
                insertDiameter / 2
            );
        }
    }
}