$fn = 128;

/**
 * A circular collar for a rectangular speaker terminal with two screw holes.
 */

// Dimensions in mm.

wall_width = 1; // Wall thickness
cylinder_height = 16 - wall_width + 1; // Depth of the cylinder.
cylinder_diameter = 54; // Diameter of the cylinder.
cylinder_collar_width = 8; // Cylinder collar width.
box_width = 25; // Box width.
box_height = 27.5; // Box height.
screwhole_diameter = 2.7; // Screwhole diameter.
screwhole_displace_x = 3.65; // Screwhole displacement horizontally.

difference() {
    difference() {
        union() {
            cylinder(
                h = cylinder_height,
                r1 = cylinder_diameter / 2,
                r2 = cylinder_diameter / 2
            );
            translate([0, 0, cylinder_height - wall_width]) cylinder(
                h = wall_width,
                r1 = cylinder_diameter / 2 + cylinder_collar_width,
                r2 = cylinder_diameter / 2 + cylinder_collar_width
            );
        }
        translate([0, 0, wall_width]) cylinder(
            h = cylinder_height,
            r1 = cylinder_diameter / 2 - wall_width,
            r2 = cylinder_diameter / 2 - wall_width
        );
    }
    
    translate([-box_width / 2, -box_height / 2, -wall_width])
    cube([box_width, box_height, wall_width * 3]);
    
    translate([-box_width / 2 - screwhole_displace_x, 0, -wall_width])
    cylinder(
        h = wall_width * 3,
        r1 = screwhole_diameter / 2,
        r2 = screwhole_diameter  / 2
    );
    
    translate([box_width / 2 + screwhole_displace_x, 0, -wall_width])
    cylinder(
        h = wall_width * 3,
        r1 = screwhole_diameter / 2,
        r2 = screwhole_diameter  / 2
    );
}