module form(length,height){
    $fn = 100;
    radius = 15;
        hull () {
      translate([-length/2,radius,0]) cylinder(r=radius,h=height);
      translate([length/2,radius,0])  cylinder(r=radius,h=height);
      translate([0,length+radius,0])  cylinder(r=radius,h=height);
     }        

  
}
module case(length, wallThickness,height) {
        difference(){
            form(length,height);
            {
              translate([0,wallThickness,wallThickness])     form(length-wallThickness*2,height-wallThickness*2);
           
            }
        }
        
}
module casing(){
    // overall size -these should exceed phone dimensions
    case(90, 16, 160);     
}
module roundedCube(x,y,thick,rd) {
$fn=16;
minkowski() {
cube([x-2*rd,y-2*rd,thick-2*rd]);
    sphere(rd);
};
};


module offsetCube(x,y,thick,rd) {
linear_extrude(height=thick) {
offset(rd) {
square([x,y]);
};
};
};

module phoneblank() {
rotate([90,0,0])union() {
// the phones dimensions plus wiggle room
cube([76,148,12]);
// the USB plug hole dimensions
translate([32,-12,3])cube([12,20,8]);
// The phone display opening -x,y slightly smaller than phone
#translate([5.5,15,13.2])roundedCube(66,120,15,4);
};
};

difference() {
casing();

translate([-38,17,7])phoneblank();
};