$fa = 1; $fs = $preview ? 0.7 : 0.4; // plus de polygones pour le rendu
// units in mm

// v2 : version moins haute
// v3 : encore moins haute + ajout de la gorge en dessous
hauteur = 63+9+4;
meplat=34;
meplat_metal=70+9+4;
base_h = 4;
ailette_ep = 6.5;
ergots_h = 9+1.5;
c1h =  base_h+ergots_h;
r = 21.5/2;

module ailette(ang)
{  
  intersection () {
    difference() {
        color ("green") cylinder(c1h,r=r);
        translate([0,0,base_h+ergots_h-1.5]) cylinder(1.5+.01,r=r-1);
    }
    color("pink") {
        rotate([0,0,ang])
        translate([0,-ailette_ep/2,base_h])
        cube([20,ailette_ep, ergots_h]);
    }
  }
}

module sansmetal() {    
    intersection () {
        color("blue") {
            translate([0,0,(hauteur-meplat)/2]) 
            cube([20,20,hauteur-meplat], center=true);
            }
        cylinder(hauteur,r1=15/2,r2=14/2);
        }    

        intersection() {
            cylinder(hauteur,r1=15/2,r2=14/2);

            // extrusion haut
            color("blue") {
                translate([0,0,-meplat/2+hauteur]) 
                cube([11,20,meplat], center=true);
            };
        }
    
    cylinder(base_h,r1=27.5/2,r2=21.5/2); // base conique

    // ailettes
    ailette(0);
    ailette(120);
    ailette(-120);
}

module metal() {
    color("orange") intersection() {
        cylinder(meplat_metal-8,r=9.5/2+0.5);

        // extrusion haut
        {
            translate([0,0,meplat_metal/2]) 
            cube([7.2+.5,20,meplat_metal], center=true);
        };
    };    
}

difference() {
sansmetal();
translate([0,0,-0.01]) metal();
translate([0,0,-0.01]) cylinder(3, r1=25/2, r2=21/2);
}
      
//translate([0,0,-2])  // décommenter si impression en une fois
difference() {
   cylinder(4.5, r=15/2);
   cylinder(4.5, r=11/2);
} 

//translate([22,0,]) difference() { // commenter si impression en une fois
   //cylinder(2, r=15/2);
   //cylinder(2, r=11/2);
//} 