$fn = 128;

ts = [12, 17, 17, 21];
t1 = 5;
t2 = 8;
l = 120;
h = 60;
r = 10;
bt = 5;

function sumVec(vec, index=0, sum=0) =
    index >= len(vec) ?
        sum :
        sumVec(vec, index+1, sum+vec[index]);

module single() {
    module f1() {
        translate([0, t2 / 2]) linear_extrude(h, scale = [1, t1 / t2])
            translate([0, -t2 / 2]) square([l, t2]);
    }
    module f2() {
        linear_extrude(h - r) square([l, t2]);
        translate([r, 0]) linear_extrude(h) square([l - 2 * r, t2]);
        translate([r, t2 / 2, h - r]) rotate([90, 0, 0]) cylinder(h = t2, r = r, center = true);
        translate([l - r, t2 / 2, h - r]) rotate([90, 0, 0]) cylinder(h = t2, r = r, center = true);
    }
    intersection() {
        f1();
        f2();
    }
}

sum = sumVec(ts);
cube([l, sum + len(ts) * t2 + t2, bt]);
for (i = [0 : len(ts)]) {
    translate([0, sum - sumVec(ts, i) + i * t2, bt]) single();
}