$fn=120;
radius = 75; // Radius der Kugel, nicht des Ständers
hoehe = 55;  // Höhe der Kalotte ohne Basisplatte
lochtiefe = 30;
lochd = 5;   // Lochdurchmesser

module kalotte(r, h) {
	difference() {
		translate([0, 0, h-r])
			difference() {
				sphere(r);
				loch(0, 0);
				for(i=[0:60:300]){
					loch(i,25);
				} // end for i
				for(i=[0:40:320]){
					loch(i,47);
				} // end for i
			} // end difference
		translate([0,0,-r])
			cube(2*r, center=true);
	} // end difference
} // end module kalotte

module loch(az, el) {
rotate(a=[el,0,az])
	difference() {
		loch2();
		sphere(r=radius-lochtiefe);
	} // end difference
} // end module loch

module loch2() 	{
	cylinder(h=radius, r=lochd/2);
	translate([0,0,radius-lochd])
		cylinder(h=lochd, r1=0, r2=lochd);	
	} //end module loch2

difference() {
	kalotte(r=radius, h=hoehe);
	cylinder(7.1, 11.05, 10.95);
	translate([0, 0, 7.1])
		cylinder(11, 10.95, 0);
} // end difference
