# SVG to Air Vent Register Generator

Transform decorative SVG patterns into custom 3D-printable air vent registers with adjustable borders, mounting frames, and airflow control fins.

## Features

- **Customizable Border**: Tapered border frame around any SVG pattern
- **Mounting Frame**: Optional hollow frame underneath for secure installation
- **Support Bars**: Structural crossbeam reinforcement
- **Airflow Fins**: Adjustable angled fins for directional airflow control
- **Fully Parametric**: All dimensions adjustable via OpenSCAD Customizer

## Quick Start

### Using Included Patterns

1. Open `svg_to_vent_register.scad` in OpenSCAD
2. Use the Customizer panel (Window → Customizer)
3. Select a pattern from the **svg_file** dropdown (5 patterns included)
4. Adjust dimensions and features as desired
5. Render (F6) and export to STL

### Using Your Own SVG

1. **Prepare Your SVG**: Run the crop script to remove whitespace and get dimensions:
   ```bash
   python3 crop_svg.py path/to/your-pattern.svg
   ```
   This creates `your-pattern-cropped-40.1x245.6.svg` with dimensions in the filename.

2. **Update OpenSCAD**: In the Customizer:
   - Set **svg_file** to "custom"
   - Enter your file path in **custom_svg_path**
   - Set **custom_svg_width** and **custom_svg_height** from the cropped filename

3. **Customize & Export**

1. Open `panel.scad` in OpenSCAD
2. Use the Customizer panel (Window → Customizer) to adjust:
   - SVG vent pattern size
   - Border width and taper
   - Frame dimensions
   - Fin count, angle, and height
3. Render (F6) and export to STL

## Requirements

- **OpenSCAD** (2021.01 or newer)
- **Python 3** (for SVG cropping script)

## File Structure

```
├── panel.scad           # Main OpenSCAD file
├── crop_svg.py          # SVG preprocessing script
├── README.md            # This file
└── examples/
    ├── svgs/            # Sample SVG patterns
    └── photos/          # Example renders and prints
```

## Parameters Guide

### Panel Dimensions
- **svg_vent_width**: Width of the SVG pattern (excluding border)
- **svg_vent_height**: Height (0 = auto-scale proportionally)
- **extrude_height**: Thickness of the main panel (default: 3mm)

### Border Settings
- **border_width**: How far border extends from panel edge (default: 10mm)
- **flat_section**: Flat border width before taper starts (must be < border_width)

### Frame Settings
- **enable_frame**: Toggle hollow mounting frame
- **frame_height**: Depth of frame below panel (default: 5mm)
- **frame_thickness**: Wall thickness (default: 2mm)
- **frame_offset**: Size adjustment (negative = smaller, positive = larger)

### Support Bars
- **support_bars**: Toggle crossbeam reinforcement
- **support_thickness**: Bar thickness (default: 2mm)
- **support_height_up/down**: Vertical extent of bars

### Fins
- **enable_fins**: Toggle airflow control fins (requires frame)
- **fin_count**: Number of fins (2-8)
- **fin_direction**: "x" or "y" axis orientation
- **fin_pitch**: Angle in degrees (0-90°)
- **fin_thickness**: Fin bar thickness (default: 2mm)
- **fin_height**: Fin length (0 = auto-calculate)

## Tips

- **SVG Preparation**: Use simple, solid-filled SVG patterns for best results
- **Print Settings**: 0.2mm layer height, 20% infill recommended
- **Orientation**: Print face-down for best surface finish on the visible side
- **Scaling**: Adjust `svg_vent_width` to match your vent opening size

## Examples

See the `examples/` folder for:
- Sample SVG patterns (geometric, floral, decorative)
- Photos of printed registers
- Various fin and border configurations

## License

Creative Commons - Attribution - Share Alike

Feel free to remix, modify, and share. Attribution appreciated!

## Credits

Created by Thomas Ng, 2025

## Changelog

### Version 1.0 (2025-12-01)
- Initial release
- Parametric border, frame, support bars, and fins
- SVG cropping utility
- OpenSCAD Customizer support
