/* ==================
 * USB-Pair Enclosure
 * ==================
 * Version 7 December 2025
 * Customizer-friendly
 */

/* [Male USB Connector:] */
// Shell length [mm]
x_male			= 27;
// Shell width [mm]
y_male			= 17;
// Shell height [mm]
z_male			= 9;
// Cable diameter [mm]
d_male_cable	= 9;
// Gap between male and female shell [mm]
x_gap				= 3;

/* [Female USB Connector Shell:] */
// Shell length [mm]
x_female			= 35;
// Shell width [mm]
y_female			= 20;
// Shell height [mm]
z_female			= 10.5;
// Cable diameter [mm]
d_female_cable	= 9;

/* [Enclosure halves:] */
// Wall thickness [mm]
wall				= 2;
// Fitting gap between halves [mm]
fitting_gap		= 0.1;
// Velcro or cable binder groove width [mm]
x_tape			= 13;

module __Customizer_Limit__ () {}  // Hide following assignments from Customizer.

x_enclosure		= x_female+x_gap+x_male+2*wall; // Enclosure outer dimensions
y_enclosure		= max(y_male,y_female)+2*wall;
z_enclosure		= max(z_male,z_female)+2*wall;

x_recess			= x_enclosure-20; // Recess labyrinth to match halves
y_recess			= max(y_male,y_female);
z_recess			= 3;

dmink				= min(3,2*wall); // minkowski() rounding diameter
 
	upper_half();
	translate([0,y_enclosure + 10,0]) lower_half();
	// Assmbled view
//	translate([0,y_enclosure/2,0]) rotate([180,0,0]) lower_half();
	
module enclosure() {
	difference() {
		minkowski(convexity=4) {
			difference() {
				union() {
					cube([x_enclosure-dmink,y_enclosure-dmink,z_enclosure-dmink],true); // Enclosure
					cube([x_tape+4*wall-dmink,y_enclosure+2*wall-dmink,z_enclosure-dmink],true); // Velcro
				}
				
				// Velcro cutout
				difference() {
					cube([x_tape+dmink,y_enclosure+dmink,z_enclosure],true);
					cube([x_enclosure-dmink,y_enclosure-dmink,z_enclosure],true);
				}
			}
			sphere(d=dmink,$fn=32);
		}
		
		// Male connector cutout (including x_gap)
		translate([(x_male+x_gap)/2+(x_female-(x_male+x_gap))/2,0,0]) cube([x_male+x_gap,y_male,z_male],true); // Shell
		rotate([0,+90,0]) cylinder(d=d_male_cable,h=x_enclosure/2,$fn=32); // Cable
		// Female connector cutout
		translate([-x_female/2+(x_female-(x_male+x_gap))/2,0,0]) cube([x_female,y_female,z_female],true); // Shell
		rotate([0,-90,0]) cylinder(d=d_female_cable,h=x_enclosure/2,$fn=32); // Cable
	}
}

module upper_half() {
	difference() {
		enclosure();
		
		// Mask lower half
		translate([0,0,(z_enclosure/2+wall)/2+z_recess/2]) cube([x_enclosure,y_enclosure+2*wall,z_enclosure/2+wall],true);
		// Recess to match lower half
		difference() {
			cube([x_enclosure,y_enclosure,z_recess],true);
			cube([x_enclosure,y_recess-fitting_gap,z_recess],true);
			cube([x_recess-fitting_gap,y_enclosure,z_recess],true);
		}
	}
}

module lower_half() {
	difference() {
		enclosure();
		
		// Mask upper half
		translate([0,0,(z_enclosure/2+wall)/2+z_recess/2]) cube([x_enclosure,y_enclosure+2*wall,z_enclosure/2+wall],true);
		// Recess to match upper half
		cube([x_enclosure,y_recess,z_recess],true);
		cube([x_recess,y_enclosure+2*wall,z_recess],true);
	}
}	
