// Flashing group: pins 2–8
const int flashPins[] = {2, 3, 4, 5, 6, 7, 8};
// Steady group: pins 9–11
const int steadyPins[] = {9, 10, 11};

unsigned long lastFlashUpdate = 0;
unsigned long flashInterval = 2000; // 1 second between flash updates

unsigned long lastSteadyUpdate = 0;
unsigned long steadyInterval = 3000; // 3 seconds between steady updates

void setup() {
  for (int i = 0; i < 7; i++) {
    pinMode(flashPins[i], OUTPUT);
  }
  for (int i = 0; i < 3; i++) {
    pinMode(steadyPins[i], OUTPUT);
    digitalWrite(steadyPins[i], HIGH); // start with all on
  }
  randomSeed(analogRead(A0)); // seed randomness
}

void loop() {
  unsigned long currentTime = millis();

  // Handle flashing pins (2–8)
  if (currentTime - lastFlashUpdate > flashInterval) {
    lastFlashUpdate = currentTime;

    int solidCount = random(0, 3); // 0–2 pins solid on
    bool used[7] = {false, false, false, false, false, false, false};

    // Turn off all first
    for (int i = 0; i < 7; i++) {
      digitalWrite(flashPins[i], LOW);
    }

    // Randomly choose pins to stay solid
    for (int i = 0; i < solidCount; i++) {
      int index;
      do {
        index = random(0, 7);
      } while (used[index]);
      used[index] = true;
      digitalWrite(flashPins[index], HIGH);
    }

    // Flash the rest
    for (int i = 0; i < 7; i++) {
      if (!used[i]) {
        digitalWrite(flashPins[i], random(0, 2)); // HIGH or LOW
      }
    }

    // Randomize next interval
    flashInterval = random(800, 2000); // 0.8–2 seconds
  }

  // Handle steady pins (9–11)
  if (currentTime - lastSteadyUpdate > steadyInterval) {
    lastSteadyUpdate = currentTime;

    int mode = random(0, 4);
    switch (mode) {
      case 0: // All on
        for (int i = 0; i < 3; i++) digitalWrite(steadyPins[i], HIGH);
        break;
      case 1: // One on, others off
        for (int i = 0; i < 3; i++) digitalWrite(steadyPins[i], LOW);
        digitalWrite(steadyPins[random(0, 3)], HIGH);
        break;
      case 2: // Two on, one off
        for (int i = 0; i < 3; i++) digitalWrite(steadyPins[i], HIGH);
        digitalWrite(steadyPins[random(0, 3)], LOW);
        break;
      case 3: // All off
        for (int i = 0; i < 3; i++) digitalWrite(steadyPins[i], LOW);
        break;
    }

    // Randomize next interval
    steadyInterval = random(2000, 5000); // 2–5 seconds
  }
}