// Pedalboard for Caline Power CP-05
// Can be adapted to match other power bricks.
//
// By Turi Scandurra
// turiscandurra.com
//
// v1.0.0 - November 2025

// Board size
board_w=200; // The overall width of the board
margin_y=50; // The partial length of the board, not including the length of the power unit
slant=15; // Degrees. Directly controls the height of the board

// Power unit size
psu_w=150;
psu_l=60;
psu_h=35;

// Settings
corner_radius=8;
$fn=48;

//

board_l=psu_l+margin_y;

function rotated_TR_corner() = 
    let(
        l = psu_l - corner_radius,
        h = psu_h,
        c = cos(slant),
        s = sin(slant),
        a = l * s + h * c,
        b = l * c - h * s
    )
    [a, b];
    
function z_on_rotated_top_side() =
    let(
        s = sin(slant),
        c = cos(slant),
        t = tan(slant),
        x0 = -(psu_h) * s,   // x of rotated top-left corner
        y0 =  (psu_h) * c    // y of rotated top-left corner
    )
    t * (-margin_y - x0) + y0;

x1 = board_w*-0.5+corner_radius;
x2 = board_w*0.5-corner_radius;

y1 = psu_l / cos(slant) - corner_radius;
y2 = rotated_TR_corner()[1];
y3 = -margin_y+corner_radius;
y4 = -psu_h / sin(slant);

z1 = z_on_rotated_top_side();
z2 = rotated_TR_corner()[0];

module main_shape(){
    hull(){
        // Bottom plane
        hull(){
            // Back
            hull(){
                translate([x2, y3, 0])
                sphere(corner_radius);

                translate([x1, y3, 0])
                sphere(corner_radius);
            }
            // Front
            hull(){
                translate([x2, y1, 0])
                sphere(corner_radius);

                translate([x1, y1, 0])
                sphere(corner_radius);
            }
        }

        // Top plane
        hull(){
            // Back
            hull(){
                translate([x2, y3, z1])
                sphere(corner_radius);

                translate([x1, y3, z1])
                sphere(corner_radius);
            }
            // Front
            hull(){
                translate([x2, y2, z2])
                sphere(corner_radius);

                translate([x1, y2, z2])
                sphere(corner_radius);
            }
        }
    }
}

difference(){
    main_shape();
    // Top cut
    translate([-board_w/2,y4,0])
    rotate([slant, 0,0])
    cube([board_w, board_l*3, psu_h]);
    // Caline cut
    rotate([slant, 0,0]) translate([psu_w/-2,0.01,0]) cube([psu_w, psu_l+1, psu_h + 1]);
    // Underside cut
    translate([psu_w*-1, board_l*-1, -psu_h])cube([psu_w*2, board_l*3, psu_h]);
}