/* [LCD:] */

// LCD Panel Dimensions
lcd					= [ 304, 124, 6 ];

// Offset of visible portion of the screen from the edges in NESW order
margin				= [ 2, 4, 10, 8 ];

// Padding to add to visible portion of the screen, in NESWZ order
padding				= [ 4, 0, 0, 0, 100 ];

/* [Case:] */

// Pedestal width and height
pedestal			= [ 200, 150 ];

// The desired angle that the screen should be at
angle				= 25;	// [0:.1:90]

/* [Other:] */

// Model quality (fragments number)
$fn					= 32;	// [32,64,128,256]

// Corner radius
r					= 2;	// [1:.1:10]

// Desired minimum wall thickness
wall_thickness		= 2.5;	// [1:.1:10]


/* [Hidden] */
N					= 0;
E					= 1;
S					= 2;
W					= 3;
Z					= 4;


difference() {
	// The case itself
	translate([ 0, 0, wall_thickness ])
	rotate([angle, 0, 0])
		union() {
			bezel(padding=[4, 0, 0, 0, 0]);
		}

	// Cut away the bottom to create a flat edge to go on a desk
	translate([-500, -500, -1000])
		cube([ 1000, 1000, 1000 ]);
}

module bezel(lcd=lcd, margin=margin, padding=padding, wall_thickness=wall_thickness, pedestal=pedestal) {
	screen = [
		lcd.x - (margin[E] + margin[W]),
		lcd.y - (margin[N] + margin[S]),

		// Set the z of the screen very high, since this will be used to cut
		// out the opening, so this represents the area the user's face will
		// be in when looking at it.
		1000
	];

	left = max(margin[E], margin[W]) - margin[W];

	case = [
		screen.x + (2 * max(margin[E], margin[W]))	+ padding[E] + padding[W],
		lcd.y										+ padding[N] + padding[S],
		lcd.z + (2 * wall_thickness)				+ padding[Z]
	];

	points = [
		[ 0,		0,		0		],
		[ case.x,	0,		0		],
		[ 0,		case.y,	0		],
		[ case.x,	case.y,	0		],

		[ 0,		0,		case.z	],
		[ case.x,	0,		case.z	],
		[ 0,		case.y,	case.z	],
		[ case.x,	case.y,	case.z	],
	];

	difference() {
		union() {
			translate([ 0, 0, -((2 * wall_thickness) + padding[Z]) ])
				hull() {
					for (p=points) {
						translate(p) sphere(r=wall_thickness);
					}
				}

			// Add the pedestal
			translate([
				(pedestal.x < case.x ? (case.x - pedestal.x) : pedestal.x) / 2,
				0,
				-300
			]) cube([ pedestal.x, pedestal.y, 300 ]);
		}

		// The space for the LCD panel
		# translate([ left + padding[W], padding[S], 0 ])
			cube([ lcd.x, lcd.y, lcd.z]);

		// The same space, but with y increased to create an opening to slide
		// the physical panel through to install it.
		translate([ left + padding[W], padding[S], 0 ])
			cube([ lcd.x, lcd.y + 1000, lcd.z]);

		// Cut out the opening for the visible portion of the screen
		translate([ margin[W] + padding[W], margin[S] + padding[S], 0 ])
			cube(screen);

		// Hollow out the pedestal
		translate([ wall_thickness, wall_thickness, 0 ])
		translate([
			(pedestal.x < case.x ? (case.x - pedestal.x) : pedestal.x) / 2,
			0,
			-300
		]) cube([ pedestal.x - (2 * wall_thickness), pedestal.y + wall_thickness, 300 ]);

		// Cut off any portion of the pedestal that sticks out behind the case
		translate([ 0, case.y + wall_thickness, -500])
			cube([ 1000, 1000, 1000 ]);
	}
}

