/* [legs] */
legLength = 100;
legBase = 35;

/* [table] */
tableSize_l = 300;
tableSize_w = 200;
plate_w = 30;

module leg(x,y) {
    translate([x,y,0])
    cube([legBase, legBase, legLength]);
}

module plate() {
    cube([tableSize_l, tableSize_w, plate_w]);
}

module table() {
    translate([0, 0, legLength])
    plate();
    
    for (y = [0, tableSize_w - legBase]) {
        for (x = [0, tableSize_l - legBase]) {
            leg(x,y);
        }
    }
}
 
table();