// File: Enclosure_lid.scad
// Description: Enclosure lid for Dodepan
// Author: Turi Scandurra
// Website: https://www.turiscandurra.com/circuits
// Date: 2024-09-20
// License: MIT License

enclosure_r = 75;
tolerance = 1.0;
wall_w = 2.4;
height = 2.4;
mount_r = enclosure_r - 3.8;
enclosure_side_r = enclosure_r * 0.866;
inset_h = 0.6;
logo_w = 45;
logo_h = 48.8;
logo_inset = 0.6;
six_angles = [0, 60, 120, 180, 240, 300];

module graphics() {
    for (angle=six_angles) {
        // Ring 1
        rotate([0,0,angle])
                translate([22, 0, 0]) rotate([0,0,30]) cylinder(h=1, r=9, center=true, $fn=6);
        
        // Ring 2
        rotate([0,0,30+angle])
                translate([33, 0, 0]) cylinder(h=1, r=8, center=true, $fn=6);

        // Ring 3
        rotate([0,0,angle])
                translate([38, 0, 0]) rotate([0,0,30]) cylinder(h=1, r=6, center=true, $fn=6);
        
        // Ring 4 A
        rotate([0,0,18.5+angle])
                translate([44, 0, 0]) rotate([0,0,-48.5])cylinder(h=1, r=4, center=true, $fn=6);
            
        // Ring 4 B
        rotate([0,0,41.5+angle])
                translate([44, 0, 0]) rotate([0,0,-11.5])cylinder(h=1, r=4, center=true, $fn=6);
    }
}

module logo() {
    difference(){
        union(){
            polygon(points=[
                [-0.0, 26.89677],
                [2.36022, 26.89677],
                [3.13389, 26.82012],
                [3.81487, 26.59015],
                [4.37819, 26.21936],
                [4.79889, 25.72022],
                [5.06094, 25.10877],
                [5.14829, 24.40106],
                [5.06094, 23.69335],
                [4.79889, 23.0819],
                [4.37819, 22.58276],
                [3.81487, 22.21197],
                [3.13389, 21.982],
                [2.36022, 21.90535],
                [-0.0, 21.90535]
            ]);
            polygon(points=[
                [9.59164, 21.80552],
                [8.83936, 21.88931],
                [8.16552, 22.14066],
                [7.60398, 22.53997],
                [7.17437, 23.06764],
                [6.90697, 23.69691],
                [6.81784, 24.40106],
                [6.90697, 25.10521],
                [7.17437, 25.73448],
                [7.60398, 26.26215],
                [8.16552, 26.66146],
                [8.83936, 26.91281],
                [9.59164, 26.9966],
                [10.34214, 26.91281],
                [11.01063, 26.66146],
                [11.57573, 26.26215],
                [12.00178, 25.73448],
                [12.27453, 25.10521],
                [12.36544, 24.40106],
                [12.27453, 23.69691],
                [12.00178, 23.06764],
                [11.57573, 22.53997],
                [11.01063, 22.14066],
                [10.34214, 21.88931]
            ]);
            polygon(points=[
                [14.2917, 26.89677],
                [16.65192, 26.89677],
                [17.42559, 26.82012],
                [18.10657, 26.59015],
                [18.66988, 26.21936],
                [19.09059, 25.72022],
                [19.35264, 25.10877],
                [19.43999, 24.40106],
                [19.35264, 23.69335],
                [19.09059, 23.0819],
                [18.66988, 22.58276],
                [18.10657, 22.21197],
                [17.42559, 21.982],
                [16.65192, 21.90535],
                [14.2917, 21.90535]
            ]);
            polygon(points=[
                [25.37363, 22.99633],
                [25.37363, 21.90535],
                [21.36624, 21.90535],
                [21.36624, 26.89677],
                [25.28093, 26.89677],
                [25.28093, 25.80579],
                [22.76384, 25.80579],
                [22.76384, 24.96438],
                [24.98145, 24.96438],
                [24.98145, 23.90905],
                [22.76384, 23.90905],
                [22.76384, 22.99633]
            ]);
            polygon(points=[
                [29.62446, 26.89677],
                [30.80101, 26.66859],
                [31.57112, 26.02684],
                [31.77434, 25.57583],
                [31.84208, 25.04995],
                [31.77434, 24.52407],
                [31.57112, 24.07306],
                [30.80101, 23.4313],
                [29.62446, 23.21025],
                [28.75453, 23.21025],
                [28.75453, 21.90535],
                [27.34267, 21.90535],
                [27.34267, 26.89677]
            ]);
            polygon(points=[
                [36.80596, 22.87511],
                [34.6953, 22.87511],
                [34.30312, 21.90535],
                [32.86274, 21.90535],
                [35.06609, 26.89677],
                [36.45656, 26.89677],
                [38.66705, 21.90535],
                [37.19815, 21.90535]
            ]);
            polygon(points=[
                [45.0, 26.89677],
                [45.0, 21.90535],
                [43.83771, 21.90535],
                [41.63436, 24.56507],
                [41.63436, 21.90535],
                [40.25102, 21.90535],
                [40.25102, 26.89677],
                [41.41331, 26.89677],
                [43.61666, 24.23706],
                [43.61666, 26.89677]
            ]);
            // Upper outline
            polygon(points=[
                [22.4999, 48.80217],
                [1.3681, 36.60185],
                [1.3681, 28.42472],
                [2.79564, 28.42472],
                [2.79564, 35.77715],
                [22.4999, 47.15299],
                [42.20416, 35.77715],
                [42.20416, 28.42472],
                [43.63193, 28.42472],
                [43.63193, 36.60185]
            ]);
            // Lower outline
            polygon(points=[
                [1.3681, 20.37743],
                [1.3681, 12.20031],
                [22.4999, -1e-05],
                [43.63193, 12.20031],
                [43.63193, 20.37743],
                [42.20416, 20.37743],
                [42.20416, 13.02478],
                [22.4999, 1.64917],
                [2.79564, 13.02478],
                [2.79564, 20.37743]
            ]);
        };
        union(){
            // D1 island
            polygon(points=[
                [2.30318, 23.03198],
                [2.88076, 23.1229],
                [3.32999, 23.39565],
                [3.62412, 23.82883],
                [3.72217, 24.40106],
                [3.62412, 24.97329],
                [3.32999, 25.40648],
                [2.88076, 25.67922],
                [2.30318, 25.77013],
                [1.41186, 25.77013],
                [1.41186, 23.03198]
            ]);
            // O island
            polygon(points=[
                [9.59164, 22.97494],
                [10.27618, 23.1532],
                [10.76106, 23.65235],
                [10.93932, 24.40106],
                [10.76106, 25.14264],
                [10.27618, 25.64891],
                [9.59164, 25.82718],
                [8.9071, 25.64891],
                [8.42222, 25.14264],
                [8.24396, 24.40106],
                [8.42222, 23.65235],
                [8.9071, 23.1532]
            ]);
            // D2 island
            polygon(points=[
                [16.59488, 23.03198],
                [17.17246, 23.1229],
                [17.62168, 23.39565],
                [17.91582, 23.82883],
                [18.01387, 24.40106],
                [17.91582, 24.97329],
                [17.62168, 25.40648],
                [17.17246, 25.67922],
                [16.59488, 25.77013],
                [15.70355, 25.77013],
                [15.70355, 23.03198]
            ]);
            // P island
            polygon(points=[
                [29.5389, 24.32263],
                [30.19492, 24.50802],
                [30.41597, 25.04995],
                [30.19492, 25.59187],
                [29.5389, 25.7844],
                [28.75454, 25.7844],
                [28.75454, 24.32263]
            ]);
            // A island
            polygon(points=[
                [36.39238, 23.91618],
                [35.75063, 25.51344],
                [35.10888, 23.91618]
            ]);
        }
    }
}

module lid(){
    rotate([0,0,-30])
    difference(){
        // Main shape
        cylinder(r=enclosure_r-wall_w-tolerance/2, h=height, $fn=6);
        // Graphics
        translate([0,0,height]) rotate([0,0,30]) scale([1.3,1.3,inset_h]) graphics();
        // Logo
        rotate([0,0,30]) scale([0.6,0.6,1])
        translate([logo_w/-2, logo_h/-2, height - logo_inset]){
            linear_extrude(height = 1)
                logo();
        }
        // Screw holes
        for (angle=six_angles) {
            rotate([0,0,angle])
                translate([mount_r-4,0,0]) 
                    cylinder(h=height, r1=1, r2=2, $fn=48);
        }
        // BOOTSEL
        rotate([0,0,30]) translate([-50.75, 9.5]) cylinder(h=height, r=1.66, $fn=64);
    }
}

// Render the part
lid();
