/*
==================================================================
Written by Steve Mentzel Luxembourg 20251213
Free to share
Respect morals and mention credits when credits are due
==================================================================

Summary: 
This code will generate a vacuum hose adapter with a flange and 
4 mounting holes for M5 screws.
The first section as commented in the code allows to modify the 
object's dimensions like inner-, outer diameter, adapter height, 
flange width and thickness as well as the mounting holes's diameter

*/

// Begin section freely customizeable part variables 
inner_diameter = 37;
outer_diameter = 46.5;
adapter_height = 45;
flange_width = 14;
flange_thickness = 7;
mount_hole_d = 5.5; // plus 0.5 slack for M5 screws
// End section freely customizeable part variables 

$fn = 100;
cut_offset = 2;
flange_diameter = outer_diameter+(2*flange_width);

// As xy 0,0 is the center of the universe
// calculate the true point of origin of the part
xy_true_zero_coord=-(flange_diameter/2);

mount_hole_lr_y = 0;// left and right y always dead center
mount_hole_fb_x = 0; // front and back x always dead center

mount_hole_lx_fy = xy_true_zero_coord+(flange_width/2);
mount_hole_rx_by = (flange_diameter/2)-(flange_width/2);

module flange() {
    difference() {
        
        // Flange cylinder
        cylinder(h = flange_thickness, 
                 r = flange_diameter / 2); 
        // Inner hole for adapter
        translate([0, 0, -1]) 
            cylinder(h = flange_thickness+cut_offset, 
                     r = outer_diameter / 2);
        // mount hole left
        translate([mount_hole_lx_fy, mount_hole_lr_y,-1]) 
            cylinder(h = flange_thickness+cut_offset, 
                     r = mount_hole_d / 2);
        // mount hole right
        translate([mount_hole_rx_by, mount_hole_lr_y,-1]) 
            cylinder(h = flange_thickness+cut_offset, 
                     r = mount_hole_d / 2);

        // mount hole front
        translate([mount_hole_fb_x, mount_hole_lx_fy,-1]) 
            cylinder(h = flange_thickness+cut_offset, 
                     r = mount_hole_d / 2);
        // mount hole back
        translate([mount_hole_fb_x, mount_hole_rx_by,-1]) 
            cylinder(h = flange_thickness+cut_offset, 
                     r = mount_hole_d / 2);
    }
}

module adapter() {
    difference() {
        // Outer cylinder
        cylinder(h = adapter_height, 
                 r = outer_diameter / 2); 
        // Inner hole
        translate([0, 0, -1]) 
            cylinder(h = adapter_height+cut_offset, 
                     r = inner_diameter / 2);
    }
}

union() {
    flange();
    adapter();
}