
// these are bitholder bushings for use with sockets, box-end wrenches, and ratchet wrenches.  
// primarily, this is useful where you need to use a standard insert bit, but you have no height clearance.

// they aren't particularly strong, but they're strong enough to sink deck screws into yellow pine -- even with an impact wrench.
// while they can withstand a lot of torque compared to typical grip torque on a screwdriver, a wrench can easily
// provide an excess of torque beyond that.  expect that you can break one or at least eventually wear it out.
// considering that they cost about $0.01-0.03 to print, this is acceptable.  

// there is an option for a 6pt model, but it may be notably weaker if used in a 12pt or open-end wrench.  
// it's intended strictly for use in a 6pt socket or box-end. i have not tried either in a flank-drive type wrench,
// but i expect that it may also underperform, as it allows more room for the displacement of plastic.

// clearances vary quite a bit among bits and wrenches, so feel free to tweak the model clearances as needed.

// i printed in PLA, with enough shells to be solid.  there are base chamfers, but on the 8mm and 5/16" models,
// the base chamfers are so small that any significant amount of elephant's foot may hinder fitment unless trimmed.

// included STLs are named as "ratchetbitholder_SIZExHEIGHT_STYLE_OPTION.stl", where:
// SIZE is the nominal wrench size
// HEIGHT is the bushing height in mm
// STYLE denotes whether the bit socket is open or closed
// OPTION mentions any other variations (i.e. 6pt vs 12pt)

mm = 25.4; // used for inch sizes

ratchetcl = 0.1; // clearance on ratchet/wrench hex
bitcl = 0.2; // clearance on bit hex

ratchetw = 10; // nominal size of ratchet
ratcheth = 13; // overall tool height
is12pt = true; // select 12pt or 6pt

bitw0 = 0.25*mm; // width of insert bit
bith = 13.2; // depth of bit pocket
sockh = 2; // height of stop/reinforcing ring

// //////////////////////////////////////////////
// derived & private
ratw = ratchetw-ratchetcl; // widths (adjusted for clearances)
bitw = bitw0+bitcl;
ratd = ratw*2/sqrt(3); // diameters (corner-corner)
bitd = bitw*2/sqrt(3);
sockd = ratd;
chamos = ratd-ratw;
$fn = 50;

mirror([0,0,1])
	intersection(){
		difference(){
			union(){
				cylinder(d = ratd,h = ratcheth,$fn = 6);
				if (is12pt)
					rotate([0,0,30])
					cylinder(d = ratd,h = ratcheth,$fn = 6);
				cylinder(d = sockd,h = sockh);
				translate([0,0,sockh])
					cylinder(d1 = sockd,d2 = ratw,h = 3);
			}
			cylinder(d = bitd,h = bith*2,center=true,$fn = 6);
		}
		union(){
			translate([0,0,ratcheth-chamos])
				cylinder(d1 = sockd,d2 = ratw,h = chamos);
			translate([0,0,chamos])
				cylinder(d = sockd,h = ratcheth-2*chamos);
			cylinder(d2 = sockd,d1 = ratw,h = chamos);
		}
	}












