include <../../../_lib/BOSL2/std.scad>

//translate([-16-65, 65+3, -102]) rotate([90, 0, 0]) import("files/Front_cover.STL");

wall = 4;
dimension_bottom = 132;
dimension_bottom2 = dimension_bottom - 4*wall;
dimension_top = 51;
height = 60;
tube = 49;
tube_height = 25;

translate([0, 0, 5])
union() {
    difference() {
        cuboid([dimension_bottom, dimension_bottom, wall], rounding = 8, edges = "Z");
        cuboid([dimension_bottom2 - 2*wall, dimension_bottom2 - 2*wall, wall], rounding = 8, edges = "Z");
        
        // holes
        translate([132/2-5, 132/2-5, -2]) cylinder(d=3.5, h=wall+2, $fn=100);
        translate([-132/2+5, 132/2-5, -2]) cylinder(d=3.5, h=wall+2, $fn=100);
        translate([132/2-5, -132/2+5, -2]) cylinder(d=3.5, h=wall+2, $fn=100);
        translate([-132/2+5, -132/2+5, -2]) cylinder(d=3.5, h=wall+2, $fn=100);
    }
    
    difference() {
        prismoid(size1=[dimension_bottom2, dimension_bottom2], size2=[dimension_top, dimension_top], h=height, rounding1 = 8, rounding2 = 1);
        prismoid(size1=[dimension_bottom2 - 2*wall, dimension_bottom2 - 2*wall], size2=[dimension_top - 2*wall, dimension_top - 2*wall], h=height - wall, rounding1 = 8, rounding2 = 1);
        cylinder(d=tube - 2*wall, h=height + 2);    
    }
    
    translate([0, 0, height])
    difference() {
        cylinder(d1=tube+2, d2=tube, h=tube_height, $fn=100);
        cylinder(d=tube - 2*wall, h=tube_height + 2, $fn=100);
    }
}
//cuboid([132,132,60], rounding=8, edges = "Z");


