// Palm III Stylus (mit Kappe + Rillen hinten)

// Maße
length = 105;        // Gesamtlänge
shaft_dia = 4.95;    // Schaftdurchmesser
tip_length = 13;     // Länge Spitze
tip_dia = 1.3;       // Spitzendurchmesser
cap_length = 7;      // Länge hintere Kappe
cap_dia = 5.5;       // Durchmesser hinten

shaft_length = length - tip_length - cap_length;

$fn = 96;  // hohe Auflösung für rundere Flächen

// Hauptkörper des Stylus
module stylus_body() {
    union() {
        // Schaft
        cylinder(h = shaft_length, d = shaft_dia);
        
        // Spitze
        translate([0,0,shaft_length])
            cylinder(h = tip_length, d1 = shaft_dia, d2 = tip_dia);
        
        // Kappe (konisch)
        translate([0,0,-cap_length])
            cylinder(h = cap_length, d1 = shaft_dia, d2 = cap_dia);
        
        // Abrundung hinten
        translate([0,0,-cap_length])
            sphere(d = cap_dia);
    }
}

// Rillen hinten: längliche Abflachungen
module grip_rills() {
    union() {
        for (i = [0:2]) {   // 3 Rillen, 120° versetzt
            rotate([0,0,i*120])
                translate([cap_dia/2,0,-cap_length/2])
                    cube([2,1.5,cap_length+2], center=true);
        }
    }
}

// Stylus mit Rillen (Subtraktion)
difference() {
    stylus_body();
    grip_rills();
}
 