/* Toothpaste Roller
By Randy Bueckman
*/


$fn=$preview ? 25:100;

in_cyl_od=10;
in_cyl_ht=65;
in_cavity_wd=3.7;
in_wall_thick=1.3;
in_knob_ht=9;
in_wing_tips=33;
in_wings_thick=4;

out_cyl_od=21.5;
out_cyl_ht=65.7;
out_cavity_wd=17.6;
out_slot_wd=2.3;

/* Rather than the original round I thought a hexagonal outer shell might be nice.  That is how I printed mine.  However the round outer shell is how the original device was designed.  Change "false" to "true" if you want the hex shape*/
shell_hex=false;

/* Simply change the background modifier, comment outone or the other, or translate one or the other to render and print. I don't believe you need to modify any of the parts because they print fine and work as designed */
%inside_cylinder();
outside_cylinder();


/* modify below if you like but this works as designed*/
module outside_cylinder(){
    difference(){
        if (shell_hex){
        cylinder(h=out_cyl_ht, d=out_cyl_od+2, $fn=6);}
        else{
        cylinder(h=out_cyl_ht, d=out_cyl_od);}

        
        //hollow out the center
        cylinder(h=out_cyl_ht+1, d=out_cavity_wd);
        
        // cut out the slot
        translate([0, out_cavity_wd/2, out_cyl_ht/2])
        cube([out_slot_wd, out_cavity_wd,out_cyl_ht+1], center=true);
        
         
    } // end difference
    
    // create a funnel
        hull(){
            if (shell_hex){
            translate([(out_cyl_od/3-out_slot_wd)/2+0.3 , out_cyl_od/2-1, out_cyl_ht/2])
            cube([out_cyl_od/4-out_slot_wd,1,out_cyl_ht], center=true);}
            
            else{
            translate([(out_cyl_od/3-out_slot_wd)/2+0.3 , out_cyl_od/2-0.5, out_cyl_ht/2])
            cube([out_cyl_od/4-out_slot_wd,1,out_cyl_ht], center=true);}
            translate([4,13,0])
            cylinder(h=out_cyl_ht, d=1);
        } // end hull

        hull(){
            translate([(-out_cyl_od/3+out_slot_wd)/2-0.3 , out_cyl_od/2-1, out_cyl_ht/2])
            cube([out_cyl_od/4-out_slot_wd,1,out_cyl_ht], center=true);
            translate([-4,13,0])
            cylinder(h=out_cyl_ht, d=1);
        } // end hull
    
    // create a port for the inner cylinder
    difference(){
          cylinder(h=2, d=out_cyl_od+3, center=true);

        
        // create a solid bottom
        hull(){
            translate([0,-1,0])
            cylinder(h=4 , d=in_cyl_od+1.5, center=true);
            translate([0,1,0])
            cylinder(h=4 , d=in_cyl_od+1.5, center=true);
        } // end hull
    }// end difference

  
} // end module


module inside_cylinder(){
    difference(){
        cylinder(h=in_cyl_ht, d=in_cyl_od);
        
        // hollow out the center
        hull(){
            translate([0,-(in_cyl_od/2)+(in_cavity_wd/2)+in_wall_thick,0])
            cylinder(h=in_cyl_ht+1, d=in_cavity_wd);
            translate([0,(in_cyl_od/2)-(in_cavity_wd/2)-in_wall_thick,0])
            cylinder(h=in_cyl_ht+1, d=in_cavity_wd);
        } // end hull
        
        // create a slot for the toothpaste tube tab
        translate([0,-in_cavity_wd, in_cyl_ht/2])
        cube([in_wall_thick, in_cavity_wd,in_cyl_ht+1], center=true);
        
    }// end difference
    
    // create a stop ring
    translate([0,0,-in_wall_thick])
    cylinder(h=in_wall_thick, d=in_cyl_od+2.5);
    
    // build the wingnut section
    translate([0,0,-in_knob_ht])
    cylinder(h=in_knob_ht, d=in_cyl_od);
    
    hull(){
        translate([in_wing_tips/2,0,-in_knob_ht])
        cylinder(h=in_knob_ht-2, d=in_wings_thick);
        translate([-in_wing_tips/2,0,-in_knob_ht])
        cylinder(h=in_knob_ht-2, d=in_wings_thick);
    }
}